/*
 * Copyright (c) 2007 Atmark Techno, Inc.
 */

#ifndef _HERMIT_TARGET_PLATFORM_MEMREGIONS_H_
#define _HERMIT_TARGET_PLATFORM_MEMREGIONS_H_

#ifndef __ASSEMBLER__

#define FLASH_MAP_FMT    ("%p:%p FLA %s bf:8K %s%s\n")
#define RAM_MAP_FMT      ("%p:%p RAM %s\n")

#define SET_MAP_START(index, _start) (regions[index].start = _start)
#define SET_MAP_SIZE(index, _size)   (regions[index].size = _size)
#define SET_MAP_NAME(index, _name)   (strcpy(regions[index].name, _name))
#define SET_MAP_BLOCK(index, _block) (strcpy(regions[index].block, _block))
#define SET_MAP_TYPE(index, _type)   (regions[index].type = _type)

#define MAP_START(index) (regions[index].start)
#define MAP_END(index)   (regions[index].start + regions[index].size - 1)
#define MAP_SIZE(index)  (regions[index].size)
#define MAP_NAME(index)  (regions[index].name)
#define MAP_BLOCK(index) (regions[index].block)
#define MAP_TYPE(index)  (regions[index].type)

#define PRINT_FLASH_MAP(index)                                \
({                                                            \
	hprintf(FLASH_MAP_FMT,                                \
		MAP_START(index),                             \
		MAP_END(index),                               \
		MAP_NAME(index),                              \
		MAP_BLOCK(index)[0] ? "bl:" : "",             \
		MAP_BLOCK(index)[0] ? MAP_BLOCK(index) : ""); \
})

#define PRINT_RAM_MAP(index)      \
({                                \
	hprintf(RAM_MAP_FMT,      \
		MAP_START(index), \
		MAP_END(index),   \
		MAP_NAME(index)); \
})

struct region_table {
	int		mode;
	char		name[64];
	int		type;
	unsigned long	start;
	unsigned long	size;
	char		block[48];
};

#define MAX_REGION_NUM 16

extern struct region_table regions[MAX_REGION_NUM];
extern void print_map(int index);

enum {
	MAP_NO_ALL = 0,
	MAP_NO_BOOTLOADER,
	MAP_NO_KERNEL,
	MAP_NO_USERLAND,
	MAP_NO_CONFIG,
	MAP_NO_5,
	MAP_NO_6,
	MAP_NO_7,
	MAP_NO_8,
	MAP_NO_9,
	MAP_NO_10,
	MAP_NO_11,
	MAP_NO_12,
	MAP_NO_13,
	MAP_NO_14,
	MAP_NO_DRAM1 = MAX_REGION_NUM - 1,
};

enum {
	MAP_MODE_UNKNOWN = 0,
	MAP_MODE_RESIZABLE,
	MAP_MODE_DYNAMIC,
	MAP_MODE_STATIC,
};

enum {
	MAP_TYPE_UNKNOWN = 0,
	MAP_TYPE_FLASH,
	MAP_TYPE_RAM,
};

/* We have three types of regions
 *  - static: user is not allow to change any parameters
 *  - dynamic: all parameters are configurable
 *  - resizable: index, name and type are configurable,
 *               any other parameter is fixed
 */
#define STATIC_REGION(_index, _name, _type, _start, _size, _block)    \
  [MAP_NO_##_index] = {                                               \
	.mode	= MAP_MODE_STATIC,                                    \
	.name	= _name,                                              \
	.type	= MAP_TYPE_##_type,                                   \
	.start	= _start,                                             \
	.size	= _size,                                              \
	.block	= _block,                                             \
  }
#define DYNAMIC_REGION(_index, _name, _type, _start, _size, _block)   \
  [MAP_NO_##_index] = {                                               \
	.mode	= MAP_MODE_DYNAMIC,                                   \
	.name	= _name,                                              \
	.type	= MAP_TYPE_##_type,                                   \
	.start	= _start,                                             \
	.size	= _size,                                              \
	.block	= _block,                                             \
  }
#define RESIZABLE_REGION(_index, _name, _type, _start, _size, _block) \
  [MAP_NO_##_index] = {                                               \
	.mode	= MAP_MODE_RESIZABLE,                                 \
	.name	= _name,                                              \
	.type	= MAP_TYPE_##_type,                                   \
	.start	= _start,                                             \
	.size	= _size,                                              \
	.block	= _block,                                             \
  }

#endif

#define FLASH_START             (0xA0000000)
#define FLASH_SIZE		(0x01000000)

#define DRAM1_START		(0x80000000)
#define DRAM1_SIZE		(0x04000000)
#define DRAM1_HERMIT		(0x83000000)

#define SRAM_SIZE		(0x00100000)
#define STACK_SIZE		(0x00100000)
#define STACK_START		(DRAM1_HERMIT + SRAM_SIZE + STACK_SIZE)

#define FLASH_BOOTLOADER_START  (FLASH_START + 0x00000000)
#define FLASH_BOOTLOADER_SIZE   (MAP_SIZE (MAP_NO_BOOTLOADER))
#define FLASH_KERNEL_START      (MAP_START(MAP_NO_KERNEL))
#define FLASH_KERNEL_SIZE       (MAP_SIZE (MAP_NO_KERNEL))
#define FLASH_USERLAND_START    (MAP_START(MAP_NO_USERLAND))
#define FLASH_USERLAND_SIZE     (MAP_SIZE (MAP_NO_USERLAND))
#define FLASH_CONFIG_START      (MAP_START(MAP_NO_CONFIG))
#define FLASH_CONFIG_SIZE       (MAP_SIZE (MAP_NO_CONFIG))

#define FLASH_OPTION_START      (FLASH_START + 0x00018000)
#define FLASH_OPTION_SIZE       (0x00008000)

#define LINUX_PARAM_ADDRESS     (DRAM1_START + 0x00000100)
#define LINUX_PARAM_SIZE        (0x00000f00)

#define LINUX_SRC_ADDRESS       (FLASH_KERNEL_START)
#define LINUX_SRC_SIZE          (FLASH_KERNEL_SIZE)
#define LINUX_LOAD_ADDRESS      (DRAM1_START + 0x00008000)

#define INITRD_SRC_ADDRESS      (FLASH_USERLAND_START)
#define INITRD_SRC_SIZE         (FLASH_USERLAND_SIZE)
#define INITRD_LOAD_ADDRESS     (DRAM1_START + 0x00800000)

#define MMU_TRANSLATION_TABLE_BASE (LINUX_LOAD_ADDRESS - 0x4000)
#define MMU_TRANSLATION_TABLE_SIZE (0x4000)

#define GUNZIP_MEM_SIZE		(0x20000)
#define GUNZIP_MEM_BASE		(DRAM1_START + DRAM1_SIZE - \
				 GUNZIP_MEM_SIZE - 0x10000)

#if !defined(__ASSEMBLER__)
unsigned int get_flash_sector_size(int sector);
#endif

#endif
