/*
 * Copyright (c) 2000 Blue Mug, Inc.  All Rights Reserved.
 */

#include <target/command.h>
#include <target/herrno.h>
#include <target/io.h>

extern char *target_profile;

const char hermit_version[]
	__attribute__ ((section(".hermit.version"))) = HERMIT_VERSION;

static int version_cmdfunc(int argc, char *argv[])
{
	hprintf("Hermit-At v%s (%s) compiled at %s, %s\n",
		hermit_version, target_profile, __TIME__, __DATE__);
	return 0;
}

const command_t version_command =
	{ "version", 0, "print Hermit version", &version_cmdfunc };

