/*
 * Decompiled with CFR 0.152.
 */
package com.momiage.app.asom.gui;

import com.momiage.app.asom.common.DebugCommon;
import com.momiage.app.asom.logic.SourceInfo;
import com.momiage.app.asom.logic.SourceTrackInfo;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.swing.JTextPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequencerThread
extends Thread {
    protected MidiChannel channel = null;
    protected Synthesizer synthesizer = null;
    protected int msecPerTick = -1;
    protected SourceInfo si = null;
    protected List<SourceTrackInfo> lsti = null;
    protected JTextPane spane = null;
    protected boolean initialized = false;

    public SequencerThread(SourceInfo sourceInfo, List<SourceTrackInfo> list, JTextPane jTextPane) {
        this.si = sourceInfo;
        this.lsti = list;
        this.spane = jTextPane;
    }

    public void init() {
        int n = this.si.getTempo();
        int n2 = 60000000 / n;
        this.msecPerTick = n2 / 24 / 1000;
        this.initialized = true;
    }

    @Override
    public void run() {
        block8: {
            if (!this.initialized) {
                this.init();
            }
            Soundbank soundbank = null;
            Instrument[] instrumentArray = null;
            try {
                this.synthesizer = MidiSystem.getSynthesizer();
                this.synthesizer.open();
                soundbank = this.synthesizer.getDefaultSoundbank();
                instrumentArray = soundbank.getInstruments();
                this.synthesizer.loadInstrument(instrumentArray[0]);
                this.channel = this.synthesizer.getChannels()[0];
                this.channel.programChange(this.si.getInstNo() - 1);
                Iterator<SourceTrackInfo> iterator = this.lsti.iterator();
                SourceTrackInfo sourceTrackInfo = null;
                if (iterator.hasNext()) {
                    sourceTrackInfo = iterator.next();
                }
                while (iterator.hasNext()) {
                    DebugCommon.print(sourceTrackInfo.toString());
                    SourceTrackInfo sourceTrackInfo2 = iterator.next();
                    int n = sourceTrackInfo.getCharpos();
                    this.spane.requestFocus();
                    this.spane.setSelectionStart(0);
                    this.spane.setSelectionEnd(n);
                    if (sourceTrackInfo.getMes() == 128) {
                        this.channel.allNotesOff();
                    } else {
                        this.channel.noteOn(sourceTrackInfo.getPitch(), 127);
                    }
                    int n2 = sourceTrackInfo2.getTick() - sourceTrackInfo.getTick();
                    if (0 < n2) {
                        SequencerThread.sleep(n2 * this.msecPerTick);
                    }
                    sourceTrackInfo = sourceTrackInfo2;
                }
                this.spane.requestFocus();
                this.spane.setSelectionStart(0);
                this.spane.setSelectionEnd(this.spane.getText().length());
                this.channel.allNotesOff();
                this.synthesizer.close();
            }
            catch (Exception exception) {
                if (this.channel == null) break block8;
                this.channel.allNotesOff();
            }
        }
    }
}

