package com.momiage.app.asom.logic;

import java.util.Hashtable;
import java.util.Set;
import java.util.TreeSet;

import com.momiage.app.asom.common.DebugCommon;

public class MusicTheory {

	protected static final int majorScale[] = { 0, 2, 2, 1, 2, 2, 2, 1, };

	protected static final int minorScale[] = { 0, 2, 1, 2, 2, 1, 2, 1, 1 };

	protected static final int naturalMinorScale[] = { 0, 2, 1, 2, 2, 1, 2, 2, };
	protected static final int harmonicMinorScale[] = { 0, 2, 1, 2, 2, 1, 3, 1, };

	protected static final String minorString = "m";

	protected static final Hashtable<String, Integer> baseNotes = new Hashtable<String, Integer>();
	static {
		baseNotes.put("A", 57);
		baseNotes.put("A#", 58);
		baseNotes.put("Bb", 58);
		baseNotes.put("B", 59);
		baseNotes.put("Cb", 59);
		baseNotes.put("B#", 60);
		baseNotes.put("C", 60);
		baseNotes.put("C#", 61);
		baseNotes.put("Db", 61);
		baseNotes.put("D", 62);
		baseNotes.put("D#", 63);
		baseNotes.put("Eb", 63);
		baseNotes.put("E", 64);
		baseNotes.put("Fb", 64);
		baseNotes.put("E#", 65);
		baseNotes.put("F", 65);
		baseNotes.put("F#", 66);
		baseNotes.put("Gb", 66);
		baseNotes.put("G", 67);
		baseNotes.put("G#", 68);
		baseNotes.put("Ab", 68);
	}

	protected static Set<Integer> getScaleNotes(int scale[], String key) {

		DebugCommon.print(baseNotes.toString());
		DebugCommon.print(key);

		int iBaseNote = baseNotes.get(key);
		iBaseNote -= (12 * 4);

		Set<Integer> scaleSet = new TreeSet<Integer>();

		int note = iBaseNote;
		int scaleIndex = 0;
		int scaleLen = scale.length;
		while (note < 120) {
			if (scaleIndex >= scaleLen) {
				scaleIndex = 0;
			}
			note += scale[scaleIndex++];
			scaleSet.add(new Integer(note));
		}

		DebugCommon.print("scaleSet = " + scaleSet.toString());
		return scaleSet;
	}

	public static Set<Integer> getMinorScaleNotes(String key) {
		return getScaleNotes(harmonicMinorScale, key);
	}

	public static Set<Integer> getMajorScaleNotes(String key) {
		return getScaleNotes(majorScale, key);
	}
}
