package com.momiage.app.asom.logic;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class SourceInfoReader extends SourceInfo {

	public static SourceInfo readSource(File f) throws IOException {

		SourceInfo si = new SourceInfo();

		List<String> all = new Vector<String>();
		List<String> body = new Vector<String>();
		boolean isBody = false;

		BufferedReader br = new BufferedReader(new FileReader(f));

		String line;
		while ((line = br.readLine()) != null) {
			all.add(line);
			if (!isBody) {
				if (line.indexOf(startPointSig) > 0) {
					isBody = true;
				}
			} else {
				if (line.indexOf(endPointSig) > 0) {
					break;
				}
				body.add(line);
			}
		}

		br.close();

		if (isBody) {
			si.sourceBody = body;
		} else {
			si.sourceBody = all;
		}

		return si;

	}

}
