#include "int_math.h"

const unsigned short int asin_table[TABLESIZE+2] = {
     0,    41,    81,   122,   163,   204,   245,   285,
   326,   367,   408,   449,   490,   531,   572,   613,
   654,   695,   736,   777,   818,   860,   901,   942,
   984,  1025,  1067,  1108,  1150,  1192,  1234,  1276,
  1318,  1360,  1402,  1444,  1487,  1529,  1572,  1615,
  1658,  1700,  1744,  1787,  1830,  1874,  1917,  1961,
  2005,  2049,  2093,  2137,  2182,  2226,  2271,  2316,
  2362,  2407,  2453,  2498,  2544,  2591,  2637,  2684,
  2731,  2778,  2825,  2873,  2921,  2969,  3018,  3066,
  3116,  3165,  3215,  3265,  3315,  3366,  3417,  3469,
  3521,  3573,  3626,  3679,  3733,  3787,  3842,  3898,
  3953,  4010,  4067,  4124,  4183,  4242,  4301,  4362,
  4423,  4485,  4548,  4612,  4676,  4742,  4809,  4877,
  4946,  5017,  5089,  5162,  5237,  5314,  5393,  5473,
  5556,  5642,  5730,  5821,  5916,  6014,  6117,  6225,
  6338,  6459,  6589,  6730,  6885,  7061,  7269,  7540,
  8192
};

set_value int_asin( set_value set ){
    unsigned short int ix;
    unsigned int   subix;
    set_value ret;
    
    ix = set.value;

    ret.sign = ((ix & I_PI) > 0);              //3,4یł sign = ix > 32767

#ifdef DEBUG
    printf("sign sign=%d %d ix=%d I_PI=%d\n", ret.sign, ((ix & I_PI) > 0), ix , I_PI);
#endif
    
    ix &= (I_PI - 1);              //1,2یɌ ix   = ix & 32767
    if(ix > I_HPI) ix = I_PI - ix; //1یɌ     ix > 16384 ix = 32768 - ix

#ifdef DEBUG
    printf("ix :%5d \n",ix);
#endif

    ix      <<= 2;
#ifdef DEBUG
   printf("ix :%5d \n",ix);
#endif

    subix   =   ix & (SUBINDEX - 1);   //`⊮ɗpTuCfbNX
    ix      >>= SUBBIT;                 //e[uԍɕϊ

#ifdef DEBUG
    printf("debug ix :%5d \n",ix);
    printf("debug subix :%5d \n",subix);
#endif

    //`⊮
    //tval = ((float)(sin_table[ix])* (SUBINDEX - subix))
    //        + ((float)sin_table[ix+1] * subix);
    //
    //     = ((float)(sin_table[ix])* (SUBINDEX)
    //       +subix*((float)sin_table[ix+1]-(float)(sin_table[ix]))
    //ret =  sin_table[ix];
    //ret += ( (sin_div_table[ix]*subix) >> SUBBIT );
    ret.value =   (sin_div_table[ix]*subix);
    ret.value +=  SUBINDEX/2;
    ret.value >>= SUBBIT;
    ret.value +=  asin_table[ix];
    
    return ret;
//    retvalue[1] = ret;
//    return (sign ? -tval : tval) / ((float)(SUBINDEX * 65535));
}
