#include "board.h"

static UNION_INT    BIT_BOARD[4];
static uchar        PIECE_BOARD[40];

uchar getBoard(uchar p){
    return ( BIT_BOARD[p>>5].ui >> ( (p&31) ) ) & 0x01;
}

uchar setBoard(uchar p){
    BIT_BOARD[p>>5].ui ^= ( 1 << ( (p&31) ) ) ;
}

void initBitBoard(){
    int cnt;
    
    for(cnt=0;cnt<X_SIZE;cnt++){
        setBoard(cnt);
        setBoard( (X_SIZE*(Y_SIZE-1))+cnt );
    }

    for(cnt=1;cnt<X_SIZE-1;cnt++){
        setBoard(cnt*11);
        setBoard( (Y_SIZE-1)+cnt*11);
    }
}

void printBitBoard(){
    printf("%08x %08x %08x %08x\n",BIT_BOARD[0],BIT_BOARD[1],BIT_BOARD[2],BIT_BOARD[3]);
}

void initPieceBoard(){
    setBoard( PIECE_BOARD[ 0] = 1+7*X_SIZE );
    setBoard( PIECE_BOARD[ 1] = 2+7*X_SIZE );
    setBoard( PIECE_BOARD[ 2] = 3+7*X_SIZE );
    setBoard( PIECE_BOARD[ 3] = 4+7*X_SIZE );
    setBoard( PIECE_BOARD[ 4] = 5+7*X_SIZE );
    setBoard( PIECE_BOARD[ 5] = 6+7*X_SIZE );
    setBoard( PIECE_BOARD[ 6] = 7+7*X_SIZE );
    setBoard( PIECE_BOARD[ 7] = 8+7*X_SIZE );
    setBoard( PIECE_BOARD[ 8] = 9+7*X_SIZE );

    PIECE_BOARD[ 9] = 0 ;
    PIECE_BOARD[10] = 0 ;
    PIECE_BOARD[11] = 0 ;
    PIECE_BOARD[12] = 0 ;
    PIECE_BOARD[13] = 0 ;
    PIECE_BOARD[14] = 0 ;
    PIECE_BOARD[15] = 0 ;
    PIECE_BOARD[16] = 0 ;
    PIECE_BOARD[17] = 0 ;
    
    setBoard( PIECE_BOARD[18] = 2+9*X_SIZE );
    setBoard( PIECE_BOARD[19] = 8+9*X_SIZE );
    PIECE_BOARD[20] = 0 ;
    PIECE_BOARD[21] = 0 ;
    
    setBoard( PIECE_BOARD[22] = 3+9*X_SIZE );
    setBoard( PIECE_BOARD[23] = 7+9*X_SIZE );
    PIECE_BOARD[24] = 0 ;
    PIECE_BOARD[25] = 0 ;

    setBoard( PIECE_BOARD[26] = 4+9*X_SIZE );
    setBoard( PIECE_BOARD[27] = 6+9*X_SIZE );
    PIECE_BOARD[28] = 0 ;
    PIECE_BOARD[29] = 0 ;

    setBoard( PIECE_BOARD[30] = 5+9*X_SIZE );
    PIECE_BOARD[31] = 0 ;

    setBoard( PIECE_BOARD[32] = 1+9*X_SIZE );
    setBoard( PIECE_BOARD[33] = 9+9*X_SIZE );
    PIECE_BOARD[34] = 0 ;
    PIECE_BOARD[35] = 0 ;

    setBoard( PIECE_BOARD[36] = 8+8*X_SIZE );
    setBoard( PIECE_BOARD[38] = 9+9*X_SIZE );
    PIECE_BOARD[37] = 0 ;
    PIECE_BOARD[39] = 0 ;
}

void printPieceBoard(){
    printf("%02x %02x %02x %02x %02x ",
            PIECE_BOARD[0],PIECE_BOARD[1],PIECE_BOARD[2],PIECE_BOARD[3],PIECE_BOARD[4] );
    printf("%02x %02x %02x %02x %02x\n",
            PIECE_BOARD[5],PIECE_BOARD[6],PIECE_BOARD[7],PIECE_BOARD[8],PIECE_BOARD[9] );

    printf("%02x %02x %02x %02x %02x ",
            PIECE_BOARD[10],PIECE_BOARD[11],PIECE_BOARD[12],PIECE_BOARD[13],PIECE_BOARD[14] );
    printf("%02x %02x %02x %02x %02x\n",
            PIECE_BOARD[15],PIECE_BOARD[16],PIECE_BOARD[17],PIECE_BOARD[18],PIECE_BOARD[19] );

    printf("%02x %02x %02x %02x %02x ",
            PIECE_BOARD[20],PIECE_BOARD[21],PIECE_BOARD[22],PIECE_BOARD[23],PIECE_BOARD[24] );
    printf("%02x %02x %02x %02x %02x\n",
            PIECE_BOARD[25],PIECE_BOARD[26],PIECE_BOARD[27],PIECE_BOARD[28],PIECE_BOARD[29] );

    printf("%02x %02x %02x %02x %02x ",
            PIECE_BOARD[30],PIECE_BOARD[31],PIECE_BOARD[32],PIECE_BOARD[33],PIECE_BOARD[34] );
    printf("%02x %02x %02x %02x %02x\n",
            PIECE_BOARD[35],PIECE_BOARD[36],PIECE_BOARD[37],PIECE_BOARD[38],PIECE_BOARD[39] );
}

test_main(){
    int i;
    for(i=0; i<128 ; i++ ){
        setBoard(i);
        printf("%08x %08x %08x %08xn",BIT_BOARD[0],BIT_BOARD[1],BIT_BOARD[2],BIT_BOARD[3]);
    }
    for(i=0; i<128 ; i++ ){
        setBoard(i);
        printf("%08x %08x %08x %08x\n",BIT_BOARD[0],BIT_BOARD[1],BIT_BOARD[2],BIT_BOARD[3]);
    }
}

main(){
    initBitBoard();
    initPieceBoard();

    printBitBoard();
    printPieceBoard();
}

