/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.AwkLvalueException;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.statement.AwkExpressionMachine;
import net.morilib.awk.value.AwkValue;

public abstract class AwkExpression {

	/**
	 * 
	 * @param namespace
	 * @param files
	 * @return
	 */
	public abstract AwkValue eval(AwkNamespace namespace,
			AwkFiles files);

	/**
	 * 
	 * @param namespace
	 * @param value
	 * @param files
	 */
	public void assign(AwkNamespace namespace, AwkValue value,
			AwkFiles files) {
		throw new AwkLvalueException("assignment to non-lvalue");
	}

	/**
	 * 
	 * @return
	 */
	public boolean isLvalue() {
		return false;
	}

	/**
	 * 
	 * @return
	 */
	public boolean maybeInputRedirect() {
		return false;
	}

	/**
	 * 
	 * @return
	 */
	public boolean maybeOutputRedirect() {
		return false;
	}

	/**
	 * 
	 * @return
	 */
	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		b.add(this);
	}

	/**
	 * 
	 * @return
	 */
	public AwkExpression compileInternally() {
		AwkExpressionMachine.Builder b;

		b = new AwkExpressionMachine.Builder();
		compileInternally(b, null, null);
		return b.get();
	}

}
