/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.statement;

import net.morilib.awk.AwkBreakException;
import net.morilib.awk.AwkContinueException;
import net.morilib.awk.expr.AwkExpression;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkString;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

public class AwkForIn extends AwkExpression {

	private AwkExpression array, stmt;
	private String name;

	/**
	 * 
	 * @param array
	 * @param stmt
	 * @param name
	 */
	public AwkForIn(AwkExpression array, AwkExpression stmt,
			String name) {
		this.array = array;
		this.stmt  = stmt;
		this.name  = name;
	}

	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue v = AwkUndefined.UNDEF;

		try {
			for(String x : array.eval(ns, o).keys()) {
				ns.assign(name, AwkString.valueOf(x));
				try {
					v = stmt.eval(ns, o);
				} catch(AwkContinueException e) {}
			}
		} catch(AwkBreakException e) {}
		return v;
	}

	public void compileInternally(AwkExpressionMachine.Builder b,
			Object brk, Object cnt) {
		Object r = new Object(), c = new Object();

		b.add(array);
		b.addPushin();
		b.addLabel(c);
		b.addGetin(name, r);
		stmt.compileInternally(b, r, c);
		b.addJmp(c);
		b.addLabel(r);
	}

}
