/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.rel;

import net.morilib.awk.AwkCastException;
import net.morilib.awk.builtin.AwkUnaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkValue;

/**
 * 関数rel.tupleの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/13
 */
public class RelTuple extends AwkUnaryArgs {

	protected RelTuple() {
		super("tuple");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1) {
		if(a1.isArray()) {
			return Relations.makeTuple(a1.toArray(), ns);
		} else {
			throw new AwkCastException("array required");
		}
	}

}
