/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.namespace.AwkNamespace;

/**
 * パッケージstatの関数を読み込みます。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/14
 */
public class AwkStatBuiltInLoader {

	/**
	 * 関数を読み込みます。
	 * 
	 * @param ns 名前空間
	 */
	public static void load(AwkNamespace ns) {
		AwkNamespace ss = ns.subnamespace("stat");

		ss.bindFunction("correlation", new Correlation());
		ss.bindFunction("covariance", new Covariance());
		ss.bindFunction("geometric", new GeometricMean());
		ss.bindFunction("harmonic", new HarmonicMean());
		ss.bindFunction("kurtosis", new Kurtosis());
		ss.bindFunction("mean", new Mean());
		ss.bindFunction("median", new Median());
		ss.bindFunction("mode", new Mode());
		ss.bindFunction("regression", new Regression());
		ss.bindFunction("skewness", new Skewness());
		ss.bindFunction("variance", new Variance());
		ss.bindFunction("varianceunbiased", new VarianceUnbiased());
		ss.bindFunction("percentile", new Percentile());

		ss.bindFunction("count", new Count());
		ss.bindFunction("histogram", new Histogram());

		ss.bindFunction("cdfbinomial", new CdfBinomial());
		ss.bindFunction("cdfchisquared", new CdfChiSquared());
		ss.bindFunction("cdfcontinuousuniform",
				new CdfContinuousUniform());
		ss.bindFunction("cdfdiscreteuniform",
				new CdfDiscreteUniform());
		ss.bindFunction("cdfexponential", new CdfExponential());
		ss.bindFunction("cdfgamma", new CdfGamma());
		ss.bindFunction("cdfnormal", new CdfNormal());
		ss.bindFunction("cdfpoisson", new CdfPoisson());
		ss.bindFunction("cdft", new CdfT());

		ss.bindFunction("binomial", new DistBinomial());
		ss.bindFunction("chisquared", new DistChiSquared());
		ss.bindFunction("continuousuniform",
				new DistContinuousUniform());
		ss.bindFunction("discreteuniform", new DistDiscreteUniform());
		ss.bindFunction("exponential", new DistExponential());
		ss.bindFunction("gamma", new DistGamma());
		ss.bindFunction("normal", new DistNormal());
		ss.bindFunction("poisson", new DistPoisson());
		ss.bindFunction("t", new DistT());

		ss.bindFunction("chisquaredtest", new ChiSquaredTest());
		ss.bindFunction("t1test", new T1TestBoth());
		ss.bindFunction("t2test", new T2Test());
	}

}
