/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.expr;

import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.value.AwkArray;
import net.morilib.awk.value.AwkValue;

/**
 * 配列参照を表す中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkArrayReferrer extends AwkExpression {

	private AwkExpression e1, e2;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param e1 配列
	 * @param e2 添字
	 */
	public AwkArrayReferrer(AwkExpression e1, AwkExpression e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	/**
	 * 配列の中間表現を取得します。
	 */
	public AwkExpression getArray() {
		return e1;
	}

	/**
	 * 添字の中間表現を取得します。
	 */
	public AwkExpression getIndex() {
		return e2;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	@Override
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		return e1.eval(ns, o).referArray(
				e2.eval(ns, o).toString(ns));
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#assign(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.value.AwkValue, net.morilib.awk.io.AwkFiles)
	 */
	@Override
	public void assign(AwkNamespace ns, AwkValue v, AwkFiles o) {
		AwkValue w;

		if(e1 instanceof AwkReferVariable ||
				e1 instanceof AwkArrayReferrer) {
			w = e1.eval(ns, o);
			if(!(w instanceof AwkArray)) {
				e1.assign(ns, new AwkArray(), o);
			}
		}
		e1.eval(ns, o).putArray(e2.eval(ns, o).toString(ns), v);
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#isLvalue()
	 */
	@Override
	public boolean isLvalue() {
		return true;
	}

}
