/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkFieldTest extends AwkTestCase {

	public void testField001() {
		ns0.setField("aaa bbb  ccc\t\tddd");
		eqs("$0", "aaa bbb  ccc\t\tddd");
		eqs("$1", "aaa");
		eqs("$2", "bbb");
		eqs("$3", "ccc");
		eqs("$4", "ddd");
		eqs("$NF", "ddd");
		und("$5");

		ns0.setField("aaa bbb  ccc\t\tddd  ");
		eqs("$0", "aaa bbb  ccc\t\tddd  ");
		eqs("$1", "aaa");
		eqs("$2", "bbb");
		eqs("$3", "ccc");
		eqs("$4", "ddd");
		und("$5");
	}

	public void testField002() {
		ns0.setField("aaa bbb  ccc\t\tddd");
		eqs("$1 = \"ff\"", "ff");
		eqs("$1", "ff");
		eqs("$0", "ff bbb ccc ddd");
		eqs("$4 = \"gg\"", "gg");
	}

	public void testField003() {
		ns0.setField("aaa bbb  ccc\t\tddd");
		eqs("$0 = \"ff  ggg \t hhh\"", "ff  ggg \t hhh");
		eqs("$1", "ff");
		eqs("$2", "ggg");
		eqs("$3", "hhh");
		eqs("$4", "");
		eqs("$0", "ff  ggg \t hhh");
	}

	public void testField004() {
		ns0.setField("aaa bbb  ccc\t\tddd");
		eqs("$5 = \"eee\"", "eee");
		eqs("$5", "eee");
		eqs("$7 = \"ggg\"", "ggg");
		eqs("$7", "ggg");
		eqs("$0", "aaa bbb ccc ddd eee  ggg");
	}

	public void testField005() {
		ns0.setField("aaa bbb  ccc\t\tddd");
		eqs("$(-1) = \"eee\"", "eee");
		eqs("$(-1)", "");
		eqs("$0", "aaa bbb  ccc\t\tddd");
	}

	public void testField006() {
		ns0.setField("100 200  300\t\t400");
		exe("a = 1");
		eqs("$a++", "100");
		eqs("$1", "101");
		eqs("++$a", "102");
		eqs("$1", "102");
		eqs("$(a++)", "102");
		eqs("$(++a)", "300");
	}

}
