/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.builtin.stat;

import net.morilib.awk.builtin.AwkQuaternaryArgs;
import net.morilib.awk.io.AwkFiles;
import net.morilib.awk.namespace.AwkNamespace;
import net.morilib.awk.stat.dist.DiscreteDistribution;
import net.morilib.awk.stat.dist.HypergeometricDistribution;
import net.morilib.awk.value.AwkUndefined;
import net.morilib.awk.value.AwkValue;

/**
 * 関数stat.rhypergeometricの記述です。
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/04/20
 */
public class RHypergeometric extends AwkQuaternaryArgs {

	protected RHypergeometric() {
		super("rhypergeometric");
	}

	@Override
	public AwkValue apply(AwkNamespace ns, AwkFiles o, AwkValue a1,
			AwkValue a2, AwkValue a3, AwkValue a4) {
		DiscreteDistribution d;
		AwkValue r;

		try {
			d = new HypergeometricDistribution(
					a1.toIntExact(),
					a2.toIntExact(),
					a3.toIntExact());
			if(a4 instanceof AwkUndefined) {
				r = AwkStatUtils.generateRandom(d);
			} else {
				r = AwkStatUtils.generateRandoms(d, a4.toIntExact());
			}
			return r;
		} catch(IllegalArgumentException e) {
			throw new AwkStatisticsException("Illegal parameter");
		}
	}

}
