/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.bc;

import junit.framework.TestCase;

public class BcLexerTest extends TestCase {

	void eqs(BcLexer l, Object s) {
		assertEquals(l.getLookahead(), s);
	}

	public void testLexer001() throws Exception {
		BcLexer l = new BcLexer("1");

		eqs(l, new BcNumber("1"));
	}

	public void testLexer002() throws Exception {
		BcLexer l = new BcLexer("1.2*3.4ABCDEF");

		eqs(l, new BcNumber("1.2"));     l.next();
		eqs(l, Character.valueOf('*'));  l.next();
		eqs(l, new BcNumber("3.4ABCDEF"));
	}

	public void testLexer003() throws Exception {
		BcLexer l = new BcLexer("+ +- -*/%!^");

		eqs(l, Character.valueOf('+'));  l.next();
		eqs(l, Character.valueOf('+'));  l.next();
		eqs(l, Character.valueOf('-'));  l.next();
		eqs(l, Character.valueOf('-'));  l.next();
		eqs(l, Character.valueOf('*'));  l.next();
		eqs(l, Character.valueOf('/'));  l.next();
		eqs(l, Character.valueOf('%'));  l.next();
		eqs(l, Character.valueOf('!'));  l.next();
		eqs(l, Character.valueOf('^'));  l.next();
	}

	public void testLexer004() throws Exception {
		BcLexer l = new BcLexer("<><=>===!=");

		eqs(l, BcRelop.LT);  l.next();
		eqs(l, BcRelop.GT);  l.next();
		eqs(l, BcRelop.LE);  l.next();
		eqs(l, BcRelop.GE);  l.next();
		eqs(l, BcRelop.EQ);  l.next();
		eqs(l, BcRelop.NE);  l.next();
	}

	public void testLexer005() throws Exception {
		BcLexer l = new BcLexer("*/*<><=>===!=* **//*aaaa*//***//");

		eqs(l, Character.valueOf('*'));  l.next();
		eqs(l, Character.valueOf('/'));  l.next();
	}

	public void testLexer006() throws Exception {
		BcLexer l = new BcLexer("abc765==__def");

		eqs(l, new BcSymbol("abc765"));  l.next();
		eqs(l, BcRelop.EQ);  l.next();
		eqs(l, new BcSymbol("__def"));  l.next();
	}

	public void testLexer007() throws Exception {
		BcLexer l = new BcLexer("\"aaaa\"==\"\\\"\"");

		eqs(l, new BcStringLiteral("aaaa"));  l.next();
		eqs(l, BcRelop.EQ);  l.next();
		eqs(l, new BcStringLiteral("\""));  l.next();
	}

}
