/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;

import net.morilib.sh.arith.ShExprLexer;
import net.morilib.sh.arith.ShExprParser;
import junit.framework.TestCase;

public class ShExprTestCase extends TestCase {

	static ShExprLexer lex(String s) {
		try {
			return new ShExprLexer(new StringReader(s));
		} catch (IOException e) {
			throw new RuntimeException(s);
		}
	}

	void eqi(ShEnvironment env, String l, long s) {
		try {
			assertEquals(ShExprParser.parseExpression(env, lex(l)), BigInteger.valueOf(s));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	void err(ShEnvironment env, String l) {
		try {
			ShExprParser.parseExpression(env, lex(l));  fail();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}

	void eqi(String l, long s) {
		eqi(new ShRootShellEnvironment(new ShRootEnvStub()), l, s);
	}

	void err(String l) {
		err(new ShRootShellEnvironment(new ShRootEnvStub()), l);
	}

}
