/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.sh.misc;

import junit.framework.TestCase;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/06/02
 */
public class KeywordMatcherTest extends TestCase {

	public void test001() {
		KeywordMatcher m = KeywordMatcher.compile(false, "key");

		assertEquals("key", m.find("key"));
		assertEquals("key", m.find("keyword"));
		assertEquals("key", m.find("akey"));
		assertNull(m.find("ke"));
		assertNull(m.find(""));
	}

	public void test002() {
		KeywordMatcher m = KeywordMatcher.compile(false, "shshe");

		assertEquals("shshe", m.find("shshe"));
		assertEquals("shshe", m.find("shshshe"));
		assertEquals("shshe", m.find("sshshe"));
		assertNull(m.find("shsh"));
		assertNull(m.find("she"));
	}

	public void test003() {
		KeywordMatcher m = KeywordMatcher.compile(false, "he", "his", "shell", "hers");

		assertEquals("he", m.find("he"));
		assertEquals("his", m.find("his"));
		assertEquals("shell", m.find("shell"));
		assertEquals("hers", m.find("hers"));
		assertEquals("hers", m.find("shers"));
		assertNull(m.find("h"));
	}

	public void test004() {
		KeywordMatcher m = KeywordMatcher.compile(true, "Key");

		assertEquals("Key", m.find("kEY"));
		assertEquals("Key", m.find("kEyword"));
		assertEquals("Key", m.find("aKEy"));
		assertNull(m.find("KE"));
		assertNull(m.find(""));
	}

	public void test005() {
		KeywordMatcher m = KeywordMatcher.compile(false, "key");

		assertEquals("key", m.matches("key"));
		assertNull(m.matches("keyword"));
		assertNull(m.matches("akey"));
		assertNull(m.matches("ke"));
		assertNull(m.matches(""));
	}

	public void test006() {
		KeywordMatcher m = KeywordMatcher.compile(false, "key");

		assertEquals("key", m.findWholeWord("key"));
		assertEquals("key", m.findWholeWord("key "));
		assertEquals("key", m.findWholeWord(" key"));
		assertEquals("key", m.findWholeWord(" key word"));
		assertNull(m.findWholeWord("keyword"));
		assertNull(m.findWholeWord(" keyword"));
		assertNull(m.findWholeWord("keyword "));
		assertNull(m.findWholeWord("akey"));
		assertNull(m.findWholeWord(" akey"));
		assertNull(m.findWholeWord("akey "));
		assertNull(m.findWholeWord("ke"));
		assertNull(m.findWholeWord(""));
	}

	public void test007() {
		KeywordMatcher m = KeywordMatcher.compile(false, "he", "his", "shell", "hers");

		assertEquals("he", m.findWholeWord("he"));
		assertEquals("he", m.findWholeWord("he "));
		assertEquals("he", m.findWholeWord(" he"));
		assertEquals("he", m.findWholeWord(" he word"));
		assertEquals("his", m.findWholeWord("his"));
		assertEquals("his", m.findWholeWord("his "));
		assertEquals("his", m.findWholeWord(" his"));
		assertEquals("his", m.findWholeWord(" his word"));
		assertEquals("shell", m.findWholeWord("shell"));
		assertEquals("shell", m.findWholeWord("shell "));
		assertEquals("shell", m.findWholeWord(" shell"));
		assertEquals("shell", m.findWholeWord(" shell word"));
		assertEquals("hers", m.findWholeWord("hers"));
		assertEquals("hers", m.findWholeWord("hers"));
		assertEquals("hers", m.findWholeWord(" hers"));
		assertEquals("hers", m.findWholeWord(" hers word"));
		assertNull(m.findWholeWord("her"));
		assertNull(m.findWholeWord(" her"));
		assertNull(m.findWholeWord("her "));
		assertNull(m.findWholeWord(""));
	}

}
