/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.dc;

import java.io.IOException;
import java.math.RoundingMode;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2013/07/14
 */
public interface DcModel extends DcVisitor {

	/**
	 * 
	 * @return
	 */
	public Object pop();

	/**
	 * 
	 * @param n
	 */
	public void pushConst(int n);

	/**
	 * 
	 */
	public void clear();

	/**
	 * 
	 */
	public void duplicate();

	/**
	 * 
	 */
	public void exchange();

	/**
	 * 
	 * @param c
	 * @param o
	 */
	public void set(int c, Object o);

	/**
	 * 
	 * @param c
	 * @return
	 */
	public Object peek(int c);

	/**
	 * 
	 * @param c
	 * @param o
	 */
	public void push(int c, Object o);

	/**
	 * 
	 * @param c
	 * @return
	 */
	public Object pop(int c);

	/**
	 * 
	 * @param r
	 */
	public void setInputRadix(int r);

	/**
	 * 
	 * @return
	 */
	public int getInputRadix();

	/**
	 * 
	 * @param r
	 */
	public void setOutputRadix(int r);

	/**
	 * 
	 * @return
	 */
	public int getOutputRadix();

	/**
	 * 
	 * @param r
	 */
	public void setScale(int r);

	/**
	 * 
	 * @return
	 */
	public int getScale();

	/**
	 * 
	 * @return
	 */
	public String readLine() throws IOException;

	/**
	 * 
	 * @return
	 */
	public int getDepthOfStack();

	/**
	 * 
	 * @param o
	 */
	public void print(Object o);

	/**
	 * 
	 * @param o
	 */
	public void printAsByte(Object o) throws IOException;

	/**
	 * 
	 * @param o
	 */
	public void println(Object o);

	/**
	 * 
	 * @param o
	 */
	public void printStackTrace();

	/**
	 * 
	 * @return
	 */
	public RoundingMode getRoundingMode();

	/**
	 * 
	 * @param m
	 */
	public void setRoundingMode(RoundingMode m);

	/**
	 * 
	 * @return
	 */
	public boolean isEmpty();

	/**
	 * 
	 * @param var
	 * @param index
	 * @return
	 */
	public Object getArray(int var, Object index);

	/**
	 * 
	 * @param var
	 * @param index
	 * @param v
	 */
	public void setArray(int var, Object index, Object v);

	/**
	 * 
	 * @param var
	 */
	public void clearArray(int var);

	/**
	 * 
	 * @param var
	 * @return
	 */
	public int getArraySize(int var);

}
