/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.printf;

import java.io.IOException;
import java.io.Writer;
import java.math.BigInteger;

import net.morilib.awk.value.AwkValue;

/**
 * %d, %x, %oのアクションです。
 * 
 * 
 * @author MORIGUCHI, Yuichiro 2013/05/11
 */
public class PrintfActionInteger implements PrintfAction {

	private int radix;
	private int upper;

	/**
	 * アクションを生成します。
	 * 
	 * @param radix 進数
	 * @param upper 大文字
	 */
	public PrintfActionInteger(int radix, boolean upper) {
		this.radix = radix;
		this.upper = upper ? 1 : 0;
	}

	String tos(Object n, int flags) {
		BigInteger l;
		String s;

		l = ((AwkValue)n).toInteger();
		s = l.toString(radix);
		s = upper == 0 ? s.toLowerCase() : s.toUpperCase();
		if((flags & Printf.SIGN) != 0) {
			if(l.signum() >= 0)  s = "+" + s;
		} else if((flags & Printf.SIGN_BLANK) != 0) {
			if(l.signum() >= 0)  s = " " + s;
		}
		return s;
	}

	public void action(Writer b, int flags, int width, int precision,
			Object arg) throws IOException {
		Printf.indentNumber(b, tos(arg, flags), flags, width);
	}

}
