/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk;

public class AwkBuiltInTest extends AwkTestCase {

	public void testGensub() {
		eqs("gensub(/a/, \"cc\", 1, \"aba\");", "ccba");
		eqs("gensub(/a/, \"cc\", 2, \"aba\");", "abcc");
		eqs("gensub(/a/, \"cc\", 3, \"aba\");", "aba");
		eqs("gensub(/a/, \"cc\", \"g\", \"aba\");", "ccbcc");
		eqs("gensub(/a/, \"cc\", \"Gen\", \"aba\");", "ccbcc");

		eqs("gensub(/a+/, \"&&\", 1, \"abaa\");", "aabaa");
		eqs("gensub(/a+/, \"&&\", 2, \"abaa\");", "abaaaa");
		eqs("gensub(/a+/, \"&&\", 3, \"abaa\");", "abaa");
		eqs("gensub(/a+/, \"&&\", \"gen\", \"abaa\");", "aabaaaa");
		eqs("gensub(/a+/, \"&&\", \"Gen\", \"abaa\");", "aabaaaa");
		eqs("gensub(/a+/, \"\\\\0\\\\0\", 1, \"abaa\");", "aabaa");

		eqs("gensub(/a+/, \"\\\\&\\\\&\", \"g\", \"abaa\");", "&&b&&");
		eqs("gensub(/a+/, \"\\\\a\", \"g\", \"abaa\");", "\\ab\\a");
		eqs("gensub(/a*/, \"a\", \"g\", \"abaaaa\");", "aabaa");
		eqs("gensub(/z/, \"cc\", \"g\", \"aba\");", "aba");
		eqs("gensub(\"a+\", \"\\\\a\", \"g\", \"abaa\");", "\\ab\\a");
		eqs("gensub(1, \"765\", \"g\", \"121\");", "7652765");

		eqs("gensub(/(a+)(b+)/, \"\\\\2\\\\1\", \"g\", \"abcaabb\");", "bacbbaa");
		eqs("gensub(/(a+)(b+)/, \"\\\\\\\\2\\\\\\\\1\", \"g\", \"abcaabb\");", "\\2\\1c\\2\\1");
		eqs("gensub(/(a+)(b+)/, \"\\\\3\", \"g\", \"abcaabb\");", "c");
	}

	public void testGsub2() {
		eqs("gsub(/\\([0-9]+\\)/, \"\", \"aaa(11)\");", "aaa");
	}

	public void testLength() {
		eqi("length(\"a\");", 1);
	}

	public void testIndex() {
		eqi("index(\"banana\", \"an\");", 2);
		eqi("index(\"banana\", \"zz\");", 0);
	}

	public void testSplit() {
		eqi("{ split(\"aaa  bbb cc\", a, \" \"); 1; }", 1);
		eqs("a[1];", "aaa");
		eqs("a[2];", "bbb");
		eqs("a[3];", "cc");
	}

	public void testGsub() {
		eqs("gsub(/a/, \"cc\", \"aba\");", "ccbcc");
		eqs("gsub(/a/, \"c&c\", \"aba\");", "cacbcac");
		eqs("gsub(/a+/, \"&&\", \"abaa\");", "aabaaaa");
		eqs("gsub(/a+/, \"\\\\&\\\\&\", \"abaa\");", "&&b&&");
		eqs("gsub(/a+/, \"\\\\a\", \"abaa\");", "\\ab\\a");
		eqs("gsub(/a*/, \"a\", \"abaaaa\");", "aabaa");
		eqs("gsub(/z/, \"cc\", \"aba\");", "aba");
		eqs("gsub(\"a+\", \"\\\\a\", \"abaa\");", "\\ab\\a");
		eqs("gsub(1, \"765\", \"121\");", "7652765");
	}

	public void testSub() {
		eqs("sub(/a/, \"cc\", \"aba\");", "ccba");
		eqs("sub(/a/, \"c&c\", \"aba\");", "cacba");
		eqs("sub(/a+/, \"&&\", \"abaa\");", "aabaa");
		eqs("sub(/a+/, \"\\\\&\\\\&\", \"abaa\");", "&&baa");
		eqs("sub(/a+/, \"\\\\a\", \"abaa\");", "\\abaa");
		eqs("sub(/a*/, \"a\", \"abaaaa\");", "abaaaa");
		eqs("sub(/z/, \"cc\", \"aba\");", "aba");
		eqs("sub(\"a+\", \"\\\\a\", \"abaa\");", "\\abaa");
		eqs("sub(1, \"765\", \"121\");", "76521");
	}

	public void testMatch() {
		eqi("match(\"abc\", /b/);", 2);
		eqi("RSTART;", 2);  eqi("RLENGTH;", 1);
		eqi("match(\"abcccde\", /c+/);", 3);
		eqi("RSTART;", 3);  eqi("RLENGTH;", 3);
		eqi("match(\"abc\", \"b\");", 2);
		eqi("RSTART;", 2);  eqi("RLENGTH;", 1);
	}

	public void testSubstr() {
		eqs("substr(\"abcdef\", 2, 3)", "bcd");
		eqs("substr(\"abcdef\", 2)", "bcdef");
		eqs("substr(\"abcdef\")", "abcdef");
	}

	public void testSprintf() {
		eqs("sprintf(\"%04d\", 765)", "0765");
		eqs("sprintf(\"%04d:%5s\", 765, \"aa\")", "0765:   aa");
		eqs("sprintf(\"Hello, world\")", "Hello, world");
		eqs("sprintf()", "");
	}

	public void testTolower() {
		eqs("tolower(\"ABCDEabcde\")", "abcdeabcde");
		eqs("tolower(\"\")", "");
	}

	public void testToupper() {
		eqs("toupper(\"ABCDEabcde\")", "ABCDEABCDE");
		eqs("toupper(\"\")", "");
	}

	public void testSrand() {
		exe("srand(765)");
		eqi("srand(841)", 765);
		eqi("srand(961)", 841);
	}

}
