﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class バージョンのテスト
    {
        Project project;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全てのバージョンが取得できる()
        {
            List<BTS.Backlog.Version> versions = project.GetVersions();

            Assert.That( versions.Count == 2 );

            Assert.That( versions[0].Id == 24903 );
            Assert.That( versions[0].Name == "Webで追加したバージョン" );
            Assert.That( versions[0].Date == DateTime.Parse( "0001/01/01 0:00:00" ) );

            Assert.That( versions[1].Id == 24904 );
            Assert.That( versions[1].Name == "Webで追加したマイルストーン" );
            Assert.That( versions[1].Date == DateTime.Parse( "2009/10/27 0:00:00" ) );
        }
    }
}
