﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class プロジェクトのテスト
    {
        Project project;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全てのプロジェクト情報が取得できる()
        {
            List<Project> projects = Project.GetAll();

            Assert.AreEqual( projects.Count,1 );
            Assert.AreEqual( projects[0].Id, 14001 );
            Assert.AreEqual( projects[0].Key, "XMLRPC" );
            Assert.AreEqual( projects[0].Name, "XML-RPC テスト" );
            Assert.AreEqual( projects[0].Url, "https://kaoruntest.backlog.jp/projects/XMLRPC" );
        }

        [Test]
        public void プロジェクトIDからプロジェクト情報が取得できる()
        {
            Project project = new Project( 14001 );

            Assert.AreEqual( project.Id, 14001 );
            Assert.AreEqual( project.Key, "XMLRPC" );
            Assert.AreEqual( project.Name, "XML-RPC テスト" );
            Assert.AreEqual( project.Url, "https://kaoruntest.backlog.jp/projects/XMLRPC" );
        }

        [Test]
        public void プロジェクトキーからプロジェクト情報が取得できる()
        {
            Project project = new Project( "XMLRPC" );

            Assert.AreEqual( project.Id, 14001 );
            Assert.AreEqual( project.Key, "XMLRPC" );
            Assert.AreEqual( project.Name, "XML-RPC テスト" );
            Assert.AreEqual( project.Url, "https://kaoruntest.backlog.jp/projects/XMLRPC" );
        }

        [Test]
        [ExpectedException( typeof( Exception ) )]
        public void 間違ったプロジェクトIDで例外が発生する()
        {
            Project project = new Project( 122121000 );
        }

        [Test]
        [ExpectedException( typeof( Exception ) )]
        public void 間違ったプロジェクトキーで例外が発生する()
        {
            Project project = new Project( "NGPROJECTKEY" );
        }

        [Test]
        [ExpectedException( typeof( XmlRpcFaultException ) )]
        public void 間違った書式のプロジェクトキーで例外が発生する()
        {
            Project project = new Project( "間違ったプロジェクトキー" );
        }
    }
}
