﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    public class User
    {
        /// <summary>
        /// ユーザー属性
        /// </summary>
        class AttributeNames
        {
            public const string ID = "id";               // ユーザーID
            public const string NAME = "name";           // ユーザー名
        }

        /// <summary>
        /// ユーザーID
        /// </summary>
        public int Id
        {
            get;
            private set;
        }

        /// <summary>
        /// ユーザー名
        /// </summary>
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public User()
        {
            Id = 0;
            Name = string.Empty;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="param"></param>
        public User( XmlRpcStruct param )
            : this()
        {
            Id = int.Parse( param[AttributeNames.ID].ToString() );
            Name = param[AttributeNames.NAME].ToString();
        }

        /// <summary>
        /// XmlRpcStruct に変換
        /// </summary>
        /// <returns></returns>
        public XmlRpcStruct ToXmlRpcStruct()
        {
            XmlRpcStruct value = new XmlRpcStruct();
            value[AttributeNames.ID] = Id;
            value[AttributeNames.NAME] = Name;

            return value;
        }

        /// <summary>
        /// ユーザーの取得
        /// </summary>
        /// <returns>ユーザー</returns>
        public static User GetUser(string userId)
        {
            XmlRpcStruct user = Backlog.Rpc.GetUser(userId);

            return new User(user);
        }

    }
}
