﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using ExcelBacklogAddIn;

namespace BTS.Backlog.Forms
{
    public partial class FormOption : Form
    {
        public ExcelBacklogAddInOption Option
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="Option"></param>
        public FormOption( ExcelBacklogAddInOption Option )
        {
            InitializeComponent();

            this.Option = Option;

            // コンボボックスの作成
            foreach ( Account Account in Option.AccountList ) {
                comboSelectUrl.Items.Add( Account.Url );
            }

            comboSelectUrl.SelectedIndex = Option.Selected;

            checkVrify.Checked = Option.UploadVerify;
        }

        /// <summary>
        /// アカウントの追加ボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAccountAdd_Click( object sender, EventArgs e )
        {
            LoginInformation form = new LoginInformation( new Account() );
            DialogResult ret = form.ShowDialog();
            if ( ret == DialogResult.OK ) {
                Option.AccountList.Add( form.Account );

                // コンボボックスに追加、もし最初の追加ならそれを選択する
                comboSelectUrl.Items.Add( form.Account.Url );
                if ( comboSelectUrl.Items.Count == 1 ) {
                    comboSelectUrl.SelectedIndex = 0;
                }
            }
        }

        /// <summary>
        /// アカウントの編集ボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAccountEdit_Click( object sender, EventArgs e )
        {
            int SelectedIndex = comboSelectUrl.SelectedIndex;
            if (SelectedIndex != -1)
            {
                LoginInformation form = new LoginInformation(Option.AccountList[SelectedIndex]);
                DialogResult ret = form.ShowDialog();
                if ( ret == DialogResult.OK ) {
                    Option.AccountList[SelectedIndex] = form.Account;

                    // コンボボックスを入れなおし、選択しなおし
                    comboSelectUrl.Items.RemoveAt( SelectedIndex );
                    comboSelectUrl.Items.Insert( SelectedIndex, form.Account.Url );
                    comboSelectUrl.SelectedIndex = SelectedIndex;
                }
            }
        }

        /// <summary>
        /// アカウントの削除ボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonAccountDelete_Click( object sender, EventArgs e )
        {
            // 選択された項目を削除する
            int SelectedIndex = comboSelectUrl.SelectedIndex;
            if ( SelectedIndex == -1 ) {
                return;
            }

            comboSelectUrl.Items.RemoveAt( SelectedIndex );
            Option.AccountList.RemoveAt( SelectedIndex );

            // アカウント情報がなくなった
            if ( comboSelectUrl.Items.Count == 0 ) {
                Option.Selected = -1;
            }
            // アイテム数と選択番号が同じになった（最後の要素の削除した）場合、
            // 直前のインデックスを選択する
            else if ( comboSelectUrl.Items.Count == SelectedIndex ) {
                Option.Selected = comboSelectUrl.SelectedIndex = SelectedIndex - 1;
            }
            // その他（削除後の街頭インデックスを選択させる）
            else {
                Option.Selected = comboSelectUrl.SelectedIndex = SelectedIndex;
            }
        }

        /// <summary>
        /// OKボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonOK_Click( object sender, EventArgs e )
        {
            Option.Selected = comboSelectUrl.SelectedIndex;
            Option.UploadVerify = checkVrify.Checked;
        }

        /// <summary>
        /// キャンセルボタン
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonCancel_Click( object sender, EventArgs e )
        {

        }
    }
}
