﻿using System;
using System.IO;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Configuration;

namespace BTS.Backlog.Forms
{
    /// <summary>
    /// ログイン情報画面
    /// </summary>
    public partial class LoginInformation : Form
    {
        public Account Account
        {
            get;
            private set;
        }

        /// <summary>
        /// デフォルトコンストラクタ
        /// </summary>
        public LoginInformation( Account bindingSource )
        {
            InitializeComponent();

            accountBindingSource.DataSource = Account = bindingSource;
        }

        /// <summary>
        /// OKボタン処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void buttonOK_Click( object sender, EventArgs e )
        {
            Close();
        }

        /// <summary>
        /// キャンセルボタン処理
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void button1_Click( object sender, EventArgs e )
        {
            Close();
        }
    }


    /// <summary>
    /// アカウント情報
    /// </summary>
    public class Account
    {
        /// <summary>
        /// 接続先URL
        /// </summary>
        public string Url
        {
            get;
            set;
        }

        /// <summary>
        /// ユーザー名
        /// </summary>
        public string UserName
        {
            get;
            set;
        }

        /// <summary>
        /// パスワード
        /// </summary>
        public string Password
        {
            get;
            set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Account()
        {
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="Url"></param>
        /// <param name="UserName"></param>
        /// <param name="Password"></param>
        public Account( string Url, string UserName, string Password )
        {
            this.Url = Url;
            this.UserName = UserName;
            this.Password = Password;
        }
    }
}
