﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class カテゴリーのテスト
    {
        Project project;
        XmlRpcStruct param;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
            param = new XmlRpcStruct();
            param["id"] = 123;
            param["name"] = "カテゴリ名";
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全てのカテゴリーが取得できる()
        {
            List<Component> components = project.GetComponents();

            Assert.That( components.Count == 2 );

            Assert.That( components[0].Id == 41940 );
            Assert.That( components[0].Name == "Webで追加したカテゴリー" );

            Assert.That( components[1].Name == "２つめのカテゴリー" );
        }

        [Test]
        public void データをパースして戻せる()
        {
            Component component = new Component( param );
            Assert.AreEqual( component.Id, param["id"] );
            Assert.AreEqual( component.Name, param["name"] );

            XmlRpcStruct ret = component.ToXmlRpcStruct();
            Assert.AreEqual( ret["id"], param["id"] );
            Assert.AreEqual( ret["name"], param["name"] );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void idがないと例外()
        {
            param.Remove( "id" );

            Component component = new Component( param );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void nameがないと例外()
        {
            param.Remove( "name" );

            Component component = new Component( param );
        }
    }
}
