﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    public class IssueType
    {
        /// <summary>
        /// ユーザー属性
        /// </summary>
        class AttributeNames
        {
            public const string ID = "id";               // ID
            public const string NAME = "name";           // 名称
            public const string COLOR = "color";         // 表示色
        }

        /// <summary>
        /// ID
        /// </summary>
        public int Id
        {
            get;
            private set;
        }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// 表示色
        /// </summary>
        public string Color
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="param"></param>
        public IssueType( XmlRpcStruct param )
        {
            Parse( param );
        }

        /// <summary>
        /// パーサ
        /// </summary>
        /// <param name="param"></param>
        public void Parse( XmlRpcStruct param )
        {
            Id = int.Parse( param[AttributeNames.ID].ToString() );
            Name = param[AttributeNames.NAME].ToString();
            Color = param[AttributeNames.COLOR].ToString();
        }
    }
}
