﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CookComputing.XmlRpc;

namespace BTS.Backlog
{
    /// <summary>
    /// 優先度
    /// </summary>
    public class Priority
    {
        /// <summary>
        /// 属性名称
        /// </summary>
        class AttributeNames
        {
            public const string ID = "id";               // ID
            public const string NAME = "name";           // 名称
        }

        /// <summary>
        /// ID
        /// </summary>
        public int Id
        {
            get;
            private set;
        }

        /// <summary>
        /// 名称
        /// </summary>
        public string Name
        {
            get;
            private set;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public Priority()
        {
            Id = 0;
            Name = string.Empty;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        /// <param name="param"></param>
        public Priority( XmlRpcStruct param )
            : this()
        {
            Id = int.Parse( param[AttributeNames.ID].ToString() );
            Name = param[AttributeNames.NAME].ToString();
        }

        /// <summary>
        /// XmlRpcStruct に変換
        /// </summary>
        /// <returns></returns>
        public XmlRpcStruct ToXmlRpcStruct()
        {
            XmlRpcStruct value = new XmlRpcStruct();
            value[AttributeNames.ID] = Id;
            value[AttributeNames.NAME] = Name;

            return value;
        }
    }
}
