﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NUnit.Framework;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace BTS.Backlog.Test
{
    [TestFixture]
    public class 課題種別のテスト
    {
        Project project;
        XmlRpcStruct param;

        [TestFixtureSetUp]
        public void TestFixtureSetUp()
        {
            Backlog.Connect( プロジェクト情報.URL, プロジェクト情報.ユーザー名, プロジェクト情報.パスワード );
            project = new Project( プロジェクト情報.デフォルトプロジェクトID );
        }

        [TestFixtureTearDown]
        public void TestFixtureTearDown()
        {
            Backlog.Close();
        }

        [SetUp]
        public void SetUp()
        {
            param = new XmlRpcStruct();
            param["id"] = 10;
            param["name"] = "優先度名";
            param["color"] = "#123456";
        }

        [TearDown]
        public void TearDown()
        {
        }

        [Test]
        public void 全ての課題種別が取得できる()
        {
            List<IssueType> issueTypes = project.GetIssueTypes();

            Assert.That( issueTypes.Count == 4 );

            Assert.That( issueTypes[0].Id == 61018 );
            Assert.That( issueTypes[0].Name == "バグ" );
            Assert.That( issueTypes[0].Color == "#990000" );

            Assert.That( issueTypes[1].Id == 61019 );
            Assert.That( issueTypes[1].Name == "タスク" );
            Assert.That( issueTypes[1].Color == "#7ea800" );

            Assert.That( issueTypes[2].Id == 61020 );
            Assert.That( issueTypes[2].Name == "要望" );
            Assert.That( issueTypes[2].Color == "#ff9200" );

            Assert.That( issueTypes[3].Id == 61021 );
            Assert.That( issueTypes[3].Name == "その他" );
            Assert.That( issueTypes[3].Color == "#2779ca" );
        }

        [Test]
        public void データをパースできる()
        {
            IssueType issueType = new IssueType( param );
            Assert.AreEqual( issueType.Id, param["id"] );
            Assert.AreEqual( issueType.Name, param["name"] );
            Assert.AreEqual( issueType.Color, param["color"] );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void idがないと例外()
        {
            param.Remove( "id" );

            IssueType issueType = new IssueType( param );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void nameがないと例外()
        {
            param.Remove( "name" );

            IssueType issueType = new IssueType( param );
        }

        [Test]
        [ExpectedException( typeof( NullReferenceException ) )]
        public void colorがないと例外()
        {
            param.Remove( "color" );

            IssueType issueType = new IssueType( param );
        }
    }
}
