﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BTS.Backlog;
using CookComputing.XmlRpc;

namespace SimpleTest
{
    class ProjectTest
    {
        static void Main( string[] args )
        {
            try {
                Backlog.Connect( "https://kaoruntest.backlog.jp", "kaoruntest", "kaoruntest" );

                Console.WriteLine( "==== Project ====" );
                List<Project> projects = Project.GetAll();
                foreach ( Project project in projects ) {
                    Console.WriteLine( "ID   : " + project.Id );
                    Console.WriteLine( "Name : " + project.Name );
                    Console.WriteLine( "Key  : " + project.Key );
                    Console.WriteLine( "Url  : " + project.Url );

                    Project specifiedProject = new Project( project.Id );
                    specifiedProject = new Project( project.Key );


                    Console.WriteLine( "==== User ====" );
                    List<User> users = project.GetUsers();
                    foreach ( User user in users ) {
                        Console.WriteLine( "ID   : " + user.Id );
                        Console.WriteLine( "Name : " + user.Name );
                    }

#if false
                    Console.WriteLine( "==== Component ====" );
                    List<Component> components = project.GetComponents();
                    foreach ( Component component in components ) {
                        Console.WriteLine( "ID   : " + component.Id );
                        Console.WriteLine( "Name : " + component.Name );
                    }

                    Console.WriteLine( "==== Version ====" );
                    List<BTS.Backlog.Version> versions = project.GetVersions();
                    foreach ( BTS.Backlog.Version version in versions ) {
                        Console.WriteLine( "ID   : " + version.Id );
                        Console.WriteLine( "Name : " + version.Name );
                        Console.WriteLine( "Date : " + version.Date.ToString() );
                    }

                    Console.WriteLine( "==== IssueType ====" );
                    List<IssueType> issueTypes = project.GetIssueTypes();
                    foreach ( IssueType issueType in issueTypes ) {
                        Console.WriteLine( "ID    : " + issueType.Id );
                        Console.WriteLine( "Name  : " + issueType.Name );
                        Console.WriteLine( "Color : " + issueType.Color );
                    }
#endif

                    Console.WriteLine( "==== IssueCount ====" );
                    Console.WriteLine( "Count: " + project.CountIssue() );

                    Console.WriteLine( "==== Issue ====" );
                    List<Issue> issues = project.GetIssues();
                    foreach ( Issue issue in issues ) {
                        //ShowIssue( issue );
                    }

                    //ShowIssue( new Issue( issues[0].Key ) );

                    Issue updateIssue = new Issue( issues[0].Id );
                    ShowIssue( updateIssue );
                    updateIssue.Description += "チケットを更新\n";
                    updateIssue.Update( "こめんとー" );
                    ShowIssue( updateIssue );

                    List<Comment> comments = updateIssue.GetComment();
                    foreach ( Comment comment in comments ) {
                        //ShowComment( comment );
                    }

                    FindIssueData countIssue = new FindIssueData();
                    countIssue.AssignerId = new int[] { updateIssue.Assigner.Id };
                    Console.WriteLine( "Assigner.Id: " + updateIssue.Assigner.Id );
                    Console.WriteLine( "Count      : " + project.CountIssue( countIssue ) );

                    countIssue.Order = true;
                    List<Issue> findIssues = project.FindIssue( countIssue );
                    foreach ( Issue issue in findIssues ) {
                        //ShowIssue( issue );
                    }

                    int newStatus = updateIssue.Status.Id + 1;
                    if ( newStatus == 5 ) {
                        newStatus = 2;
                    }
                    Status status = new Status( newStatus );
                    status.AssignerId = users[0].Id;
                    status.ResolutionId = 4;
                    //updateIssue.SwitchStatus( status, "状態を変更" );

                    //project.CreateIssue( updateIssue );

                    Issue newIssue = new Issue();
                    newIssue.Summary = "XML-RPC で登録";
                    //project.CreateIssue( newIssue );
                }
            }
            catch ( Exception ex ) {
                Console.WriteLine( ex.Message );
            }
        }

        static void ShowComment( Comment comment )
        {
            Console.WriteLine( "ID           : " + comment.Id );
            Console.WriteLine( "Content      : " + comment.Content );
            Console.WriteLine( "CreatedUser  : " + comment.CreatedUser.Id );
            Console.WriteLine( "CreatedUser  : " + comment.CreatedUser.Name );
            Console.WriteLine( "CreatedOn    : " + comment.CreatedOn.ToString() );
            Console.WriteLine( "UpdatedOn    : " + comment.UpdatedOn.ToString() );
        }

        static void ShowIssue( Issue issue )
        {
            Console.WriteLine( "ID           : " + issue.Id );
            Console.WriteLine( "Summary      : " + issue.Summary );
            Console.WriteLine( "Key          : " + issue.Key );
            Console.WriteLine( "Url          : " + issue.Url );
            Console.WriteLine( "Description  : " + issue.Description );
            Console.WriteLine( "Assigner     : " + issue.Assigner.Id );
            Console.WriteLine( "Assigner     : " + issue.Assigner.Name );
            Console.WriteLine( "CreatedUser  : " + issue.CreatedUser.Id );
            Console.WriteLine( "CreatedUser  : " + issue.CreatedUser.Name );
            Console.WriteLine( "DueDate      : " + issue.DueDate.ToString() );
            Console.WriteLine( "StartDate    : " + issue.StartDate.ToString() );
            Console.WriteLine( "CreateOn     : " + issue.CreateOn.ToString() );
            Console.WriteLine( "UpdatedOn    : " + issue.UpdatedOn.ToString() );

            Console.WriteLine( "Status       : " + issue.Status.Id );
            Console.WriteLine( "Status       : " + issue.Status.Name );

            Console.WriteLine( "Resolution   : " + issue.Resolution.Id );
            Console.WriteLine( "Resolution   : " + issue.Resolution.Name );

            foreach ( Component component in issue.Components ) {
                Console.WriteLine( "Components   : " + component.Id );
                Console.WriteLine( "Components   : " + component.Name );
            }

            foreach ( BTS.Backlog.Version version in issue.Versions ) {
                Console.WriteLine( "Versions     : " + version.Id );
                Console.WriteLine( "Versions     : " + version.Name );
                Console.WriteLine( "Versions     : " + version.Date.ToString() );
            }

            foreach ( BTS.Backlog.Version milestone in issue.Milestones ) {
                Console.WriteLine( "Milestones   : " + milestone.Id );
                Console.WriteLine( "Milestones   : " + milestone.Name );
                Console.WriteLine( "Milestones   : " + milestone.Date.ToString() );
            }
            Console.WriteLine( "" );
        }
    }
}
