package jp.progremaster.bakuhigashi;

import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import jp.progremaster.bakuhigashi.controller.Controller;
import jp.progremaster.bakuhigashi.frame.MainFrame;
import jp.progremaster.bakuhigashi.model.Model;
import jp.progremaster.bakuhigashi.view.View;

public class Bakuhigashi {
    private Bakuhigashi() {
    }

    public static void main(String[] args) {
	Model model = new Model();
	Controller controller = new Controller(model);
	Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(
		controller, 0, 16, TimeUnit.MILLISECONDS);
	new MainFrame(new View(model), controller);
    }
}
