package jp.progremaster.bakuhigashi.controller;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import jp.progremaster.bakuhigashi.model.Bomb;
import jp.progremaster.bakuhigashi.model.Fire;
import jp.progremaster.bakuhigashi.model.Model;
import jp.progremaster.bakuhigashi.model.landform.Block;

public class Controller implements Runnable {
    private static final int RESOLUTION = 8;
    private Model model;
    private List<Input> inputs;

    public Controller(Model model) {
	this.model = model;
	this.inputs = new ArrayList<Input>();
    }

    @Override
    public void run() {
	try {
	    List<Input> inputs = this.inputs;
	    this.inputs = new ArrayList<Input>();
	    for (Input input : inputs) {
		int x = model.getPlayers().get(0).x;
		int y = model.getPlayers().get(0).y;
		int velocity = 1;
		switch (input) {
		case PRESSED_UP:
		    if (model.getField().landform[toCell(y - velocity)][(x + (RESOLUTION / 2))
			    / RESOLUTION] instanceof Block) {
			break;
		    }
		    model.getPlayers().get(0).y -= velocity;
		    break;
		case PRESSED_DOWN:
		    if (model.getField().landform[(y + velocity) / RESOLUTION][(x + (RESOLUTION / 2))
			    / RESOLUTION] instanceof Block) {
			break;
		    }
		    model.getPlayers().get(0).y += velocity;
		    break;
		case PRESSED_LEFT:
		    if (model.getField().landform[(y + (RESOLUTION / 2))
			    / RESOLUTION][(x - velocity) / RESOLUTION] instanceof Block) {
			break;
		    }
		    model.getPlayers().get(0).x -= velocity;
		    break;
		case PRESSED_RIGHT:
		    if (model.getField().landform[(y + (RESOLUTION / 2))
			    / RESOLUTION][(x + velocity) / RESOLUTION] instanceof Block) {
			break;
		    }
		    model.getPlayers().get(0).x += velocity;
		    break;
		case PRESSED_BOMB:
		    model.getBombs()
			    .add(model.getPlayers().get(0).createBomb());
		    break;
		}
	    }

	    for (Iterator<Bomb> i = model.getBombs().iterator(); i.hasNext();) {
		Bomb bomb = i.next();
		bomb.timer--;
		if (bomb.timer <= 0) {
		    model.getFires().add(bomb.explode());
		    i.remove();
		}
	    }
	    for (Iterator<Fire> i = model.getFires().iterator(); i.hasNext();) {
		Fire fire = i.next();
		fire.update();
		if (fire.timer <= 0) {
		    i.remove();
		}
	    }
	    for (Fire fire : model.getFires()) {
		if (fire.x - model.getPlayers().get(0).x == 0) {
		    if (fire.y - fire.power * RESOLUTION < model.getPlayers()
			    .get(0).y
			    && model.getPlayers().get(0).y < fire.y
				    + fire.power * RESOLUTION) {
			model.getPlayers().get(0).damage();
		    }
		}
		if (fire.y - model.getPlayers().get(0).y == 0) {
		    if (fire.x - fire.power * RESOLUTION < model.getPlayers()
			    .get(0).x
			    && model.getPlayers().get(0).x < fire.x
				    + fire.power * RESOLUTION) {
			model.getPlayers().get(0).damage();
		    }
		}
	    }
	} catch (Exception e) {
	    e.printStackTrace();
	}
    }

    public void addInput(Input input) {
	inputs.add(input);
    }

    private final int toCell(int position) {
	return (position + RESOLUTION / 2) / RESOLUTION;
    }
}
