package jp.progremaster.bakuhigashi.frame;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import javax.swing.JFrame;
import javax.swing.JPanel;

import jp.progremaster.bakuhigashi.controller.Controller;
import jp.progremaster.bakuhigashi.controller.Input;
import jp.progremaster.bakuhigashi.view.View;

public class MainFrame extends JFrame {
    private static final long serialVersionUID = 1910332831754652805L;

    public MainFrame(View view, Controller controller) {
	setTitle("Hello Worldを表示する");
	getContentPane().add(new MainPanel(view, controller));
	pack();
	setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	setVisible(true);
    }
}

class MainPanel extends JPanel implements KeyListener {
    private static final long serialVersionUID = -153411121251971481L;
    private static final int WIDTH = 240;
    private static final int HEIGHT = 240;
    private Controller controller;
    private View view;

    public MainPanel(View view, Controller controller) {
	this.view = view;
	this.controller = controller;
	setPreferredSize(new Dimension(WIDTH, HEIGHT));
	setFocusable(true);
	addKeyListener(this);
	Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(
		new Runnable() {
		    public void run() {
			repaint();
		    }
		}, 0, 16, TimeUnit.MILLISECONDS);
    }

    public void paintComponent(Graphics g) {
	super.paintComponent(g);
	view.draw(g);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
	switch (e.getKeyCode()) {
	case KeyEvent.VK_UP:
	    controller.addInput(Input.PRESSED_UP);
	    break;
	case KeyEvent.VK_DOWN:
	    controller.addInput(Input.PRESSED_DOWN);
	    break;
	case KeyEvent.VK_LEFT:
	    controller.addInput(Input.PRESSED_LEFT);
	    break;
	case KeyEvent.VK_RIGHT:
	    controller.addInput(Input.PRESSED_RIGHT);
	    break;
	case KeyEvent.VK_X:
	    controller.addInput(Input.PRESSED_BOMB);
	    break;
	}
    }

    @Override
    public void keyReleased(KeyEvent e) {
	switch (e.getKeyCode()) {
	case KeyEvent.VK_UP:
	    controller.addInput(Input.RELEASED_UP);
	    break;
	case KeyEvent.VK_DOWN:
	    controller.addInput(Input.RELEASED_DOWN);
	    break;
	case KeyEvent.VK_LEFT:
	    controller.addInput(Input.RELEASED_LEFT);
	    break;
	case KeyEvent.VK_RIGHT:
	    controller.addInput(Input.RELEASED_RIGHT);
	    break;
	case KeyEvent.VK_X:
	    controller.addInput(Input.RELEASED_BOMB);
	    break;
	}
    }
}
