package jp.progremaster.bakuhigashi.view;

import java.awt.Graphics;

import jp.progremaster.bakuhigashi.model.Bomb;
import jp.progremaster.bakuhigashi.model.Fire;
import jp.progremaster.bakuhigashi.model.Model;
import jp.progremaster.bakuhigashi.model.landform.Block;

public class View {
    private static final int RESOLUTION = 8;

    private Model model;

    public View(Model model) {
	this.model = model;
    }

    public void draw(Graphics g) {
	if (model.getPlayers().get(0).life > 0) {
	    drawField(g, "＠", model.getPlayers().get(0).x, model.getPlayers()
		    .get(0).y);
	}
	for (Bomb bomb : model.getBombs()) {
	    drawField(g, "●", bomb.x, bomb.y);
	}
	for (Fire fire : model.getFires()) {
	    for (int y = -fire.power, lenY = fire.power + 1; y < lenY; y++) {
		for (int x = -fire.power, lenX = fire.power + 1; x < lenX; x++) {
		    if (x == 0 || y == 0) {
			drawField(g, "□", fire.x + x * RESOLUTION, fire.y + y
				* RESOLUTION);
		    }
		}
	    }
	}
	for (int y = 0, lenY = model.getField().landform.length; y < lenY; y++) {
	    Block[] row = model.getField().landform[y];
	    for (int x = 0, lenX = row.length; x < lenX; x++) {
		Block col = row[x];
		if (col instanceof Block) {
		    drawCell(g, "■", x, y);
		}
	    }
	}
    }

    private void drawCell(Graphics g, String character, int x, int y) {
	drawField(g, character, x * RESOLUTION, y * RESOLUTION);
    }

    private void drawField(Graphics g, String character, int x, int y) {
	int fontHalfSize = g.getFont().getSize() / 2;
	g.drawString(character, x - fontHalfSize, y + fontHalfSize);
    }
}
