/*
Copyright 2009 senju@users.sourceforge.jp

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package net.excentrics.bandWidth.sample;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

import net.excentrics.bandWidth.SocketChannelWriter;

/**
 * サンプルのWEBサーバー
 * <p>
 * コマンドライン引数
 * <table>
 * <tr>
 * <td>1</td>
 * <td>帯域幅(Kbps)</td>
 * </tr>
 * <tr>
 * <td>2</td>
 * <td>送信するファイルのパス(jpeg)</td>
 * </tr>
 * </table>
 * 
 * @author senju
 * 
 */
public class OneFileWebServer {

	/**
	 * @param args
	 *            コマンドライン引数
	 */
	public static void main(String[] args) {
		final int bps = Integer.parseInt(args[0]) * 1024; // kbpsをbpsに変換

		try {
			// 送信するファイルとバッファーのセットアップ
			final ByteBuffer buf = ByteBuffer.allocate(13000);
			final FileInputStream in = new FileInputStream(args[1]);
			final FileChannel file = in.getChannel();

			// サーバーのセットアップ
			final ServerSocketChannel ssc = ServerSocketChannel.open();
			ssc.socket().bind(new InetSocketAddress(8080));

			// 1コネクション受け付け
			final SocketChannel sc = ssc.accept();

			// リクエストを受信する
			sc.read(buf);
			buf.clear();
			// HTTPの頭の部分を送信
			final String respHeader = "HTTP/1.0 200 OK\nContent-Type: image/jpeg\nConnection: Close\n\n";
			buf.put(respHeader.getBytes("ascii"));
			buf.flip();
			sc.write(buf);
			buf.clear();

			// SocketChannelWriteの準備
			final SocketChannelWriter scw = new SocketChannelWriter(sc, bps);
			long sleeptime = 0;
			boolean isEof = false;
			for (;;) {
				if (!isEof && file.read(buf) == -1) {
					isEof = true;
				}

				Thread.sleep(sleeptime);
				buf.flip();
				sleeptime = scw.write(buf);
				if (isEof && !buf.hasRemaining()) {
					// 読み込みが終了しバッファも空の場合
					break;
				}
				buf.compact();
			}

			// クローズ
			ssc.close();

		} catch (final IOException e) {
			e.printStackTrace();
		} catch (final InterruptedException e) {
			e.printStackTrace();
		}

	}
}
