/*
Copyright 2009 senju@users.sourceforge.jp

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

package net.excentrics.bandWidth;

class SizeAndInterval {
	private int sizeInByte;
	private long intervalInMils;

	public SizeAndInterval(int size, long interval) {
		this.setSizeInByte(size);
		this.setIntervalInMils(interval);
	}

	@Override
	public String toString() {
		return "size: " + sizeInByte + " interval: " + intervalInMils;
	}

	/**
	 * @return the sizeInByte
	 */
	public int getSizeInByte() {
		return sizeInByte;
	}

	/**
	 * @return the intervalInMils
	 */
	public long getIntervalInMils() {
		return intervalInMils;
	}

	/**
	 * @param sizeInByte
	 *            the sizeInByte to set
	 */
	public void setSizeInByte(int sizeInByte) {
		this.sizeInByte = sizeInByte;
	}

	/**
	 * @param intervalInMils
	 *            the intervalInMils to set
	 */
	public void setIntervalInMils(long intervalInMils) {
		this.intervalInMils = intervalInMils;
	}
}