/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * bdcdec.c
 * Copyright (C) Koichi Akabe 2009 <mail@vbkaisetsu.com>
 * 
 * bdcdec.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * bdcdec.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "aes.h"
#include "bdcdec.h"

#define CHUNK_LEN 0x18000

void aes16ecb(char key[], char en[], char de[])
{
	int data[4];
	memcpy(data, en, 16);
	KeyExpansion(key);
	Cipher(data);
	memcpy(de, data, 16);
}

const int IV[] = {0xDDF8A00B, 0xB31FA6FE, 0x569FDFD8, 0x780F056A};

void aes16cbc_d(char key[], char en[], char de[])
{
	int data[1532];
	int i;
	KeyExpansion(key);
	memcpy(data, en, 6128);
	
	for(i = 1524; i >= 0; i -= 4)
	{
		invCipher(data + i + 4);
		data[i + 4] ^= data[i];
		data[i + 5] ^= data[i + 1];
		data[i + 6] ^= data[i + 2];
		data[i + 7] ^= data[i + 3];
	}
	invCipher(data);
	data[0] ^= IV[0];
	data[1] ^= IV[1];
	data[2] ^= IV[2];
	data[3] ^= IV[3];
	memcpy(de, data, 6128);
}

void computeBlockKey(char key[], char seed[], char blockKey[])
{
	int i;
	aes16ecb(key, seed, blockKey);
	for(i = 0; i < 16; i++)
	{
		blockKey[i] ^= seed[i];
	}
}

/*
 * fp: m2ts file
 * key: 32 bit key
 * group: index of 6144 byte group
 * decodedData: target of decoded data
 *
 * return code
 * 0: Success
 * -1: file I/O error
 */

int m2tsDecrypt(FILE *fp, char key[], long block, char decodedData[])
{
	char data[6144];
	
	// seek
	int i;
	fpos_t fpos;
	fgetpos(fp, &fpos);
	fpos.__pos = (long long)block * 6144;
	if(fsetpos(fp, &fpos) != 0)
		return -1;
	
	// read datas
	char blockKey[16];
	if(fread(data, sizeof(char), 6144, fp) != 6144)
		return -1;
	for(i = 15; i >= 0; i--)
	{
		if(key[i] != 0)
			goto decode;
	}
	memcpy(decodedData, data, 6144);
	return 0;
decode:
	// decode
	computeBlockKey(key, data, blockKey);

	aes16cbc_d(blockKey, data + 16, decodedData + 16);
	memcpy(decodedData, data, 16);
	for(i = 5952; i >= 0; i -= 192)
		decodedData[i] &= 0x3f;
	return 0;
}

