/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) Koichi Akabe 2009 <mail@vbkaisetsu.com>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 *  You should configure with "-fopenmp -O3 -D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64 -lSDL -lavcodec -lavformat -lswscale" parameters.
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <pthread.h>
#include "bdcdec/bdcdec.h"
#include "m2ts/m2ts.h"
#include "libswscale/swscale.h"
#include "bdplayback.h"

void scrEvent(struct BD_MovieData* mdata)
{
	
}

int main(int argc, char *argv[])
{	
	pthread_t play_thread; //, event_thread;
	m2tsInitialize();
	av_register_all();
	avcodec_init();
	avcodec_register_all();
	long mark;
	int track;
	unsigned long timestamp;
	char scaned[1024];
	int i, c;
	
	char key[] = {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}; // you have to change this key
	//char key[] = {0x83,0x00,0xCE,0x70,0xE1,0x63,0x1B,0x38,0x0B,0x00,0x4F,0x37,0x56,0x96,0x88,0x8D}; // you have to change this key
	
	char bdpath[1024];
	
	if(argc >= 2)
		strcpy(bdpath, argv[1]);
	else
		sprintf(bdpath, "/media/cdrom0"); // disc mounted path
		
	struct BD_MovieData mdata;
	
	memcpy(mdata.key, key, 16); // set key
	
	if(bdpb_setMovie(&mdata, bdpath, 0) != 0)
	{
		printf("ERROR: can't initialize\n");
		return 0;
	}
	
	// track numbers
	mdata.pids[0] = 0x1011; // video stream
	mdata.pids[1] = 0x1100; // audio stream
	mdata.pids[2] = 0x1200; // sub picture stream
	mdata.pids[3] = 0xffff; // undefined
	
	bdpb_playback(&mdata);
	bdpb_seek(&mdata, mdata.pl.mark_timestamp[0]);
	pthread_create(&play_thread, NULL, (void*)bdpb_playloopf, (void*)&mdata);
	
	//pthread_create(&event_thread, NULL, (void*)scrEvent, (void*)&mdata);
	/*
	pthread_join(play_thread, (void*)&thread_ret);
	if(thread_ret != 0)
	{
		printf("ERROR\n");
	}
	*/
	while(1)
	{
		i = 0;
		while(1)
		{
			scaned[i + 1] = 0;
			c = getchar();
			scaned[i] = (char)c;
			if(c == 0x0a)
				break;
			if(c != -1)
			{
				i++;
			}
		}
		if(scaned[0] == 0x6d && scaned[1] == 0x61 && scaned[2] == 0x72 && scaned[3] == 0x6b && scaned[4] == 0x20) // mark
		{
			bdpb_pause(&mdata);
			sscanf(scaned, "mark %ld\n", &mark);
			bdpb_seek(&mdata, mdata.pl.mark_timestamp[mark]);
			printf("INFO: seek to %lu\n", mdata.pl.mark_timestamp[mark]);
		}
		else if(scaned[0] == 0x74 && scaned[1] == 0x69 && scaned[2] == 0x6d && scaned[3] == 0x65 && scaned[4] == 0x20) // time
		{
			bdpb_pause(&mdata);
			sscanf(scaned, "time %lu\n", &timestamp);
			bdpb_seek(&mdata, timestamp);
			printf("INFO: seek to %lu\n", timestamp);
		}
		else if(scaned[0] == 0x76 && scaned[1] == 0x69 && scaned[2] == 0x64 && scaned[3] == 0x65 && scaned[4] == 0x6f && scaned[5] == 0x20) // video
		{
			sscanf(scaned, "video %d\n", &track);
			bdpb_changeVideoTrack(&mdata, track);
			printf("INFO: video track changed to %d\n", track);
		}
		else if(scaned[0] == 0x61 && scaned[1] == 0x75 && scaned[2] == 0x64 && scaned[3] == 0x69 && scaned[4] == 0x6f && scaned[5] == 0x20) // video
		{
			sscanf(scaned, "audio %d\n", &track);
			bdpb_changeAudioTrack(&mdata, track);
			printf("INFO: audio track changed to %d\n", track);
		}
		else if(scaned[0] == 0x73 && scaned[1] == 0x75 && scaned[2] == 0x62 && scaned[3] == 0x74 && scaned[4] == 0x69 && scaned[5] == 0x74 && scaned[6] == 0x6c && scaned[7] == 0x65 && scaned[8] == 0x20) // video
		{
			sscanf(scaned, "subtitle %d\n", &track);
			bdpb_changeSubpictureTrack(&mdata, track);
			printf("INFO: subtitle track changed to %d\n", track);
		}
		else if(strcmp(scaned, "pause\n") == 0) // pause
		{
			bdpb_pause(&mdata);
			printf("INFO: pause\n");
		}
		else if(strcmp(scaned, "playback\n") == 0) // play
		{
			bdpb_playback(&mdata);
			printf("INFO: playback\n");
		}
		else if(strcmp(scaned, "stop\n") == 0) // stop
		{
			bdpb_stop(&mdata);
			printf("INFO: stop\n");
		}
		else
		{
			printf("ERROR: unknown command\n");
		}
	}
	return (0);
}


