/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * playback.h
 * Copyright (C) Koichi Akabe 2009 <mail@vbkaisetsu.com>
 * 
 * playback.h is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * playback.h is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include "libavcodec/avcodec.h"
#include "libavformat/avformat.h"
#include "libswscale/swscale.h"
#include "SDL/SDL.h"

struct BD_PlayList
{
	unsigned char version[4];
	
	unsigned char appinf_pl_type;
	unsigned short appinf_pl_count;
	unsigned long appinf_pl_uomask;
	unsigned long appinf_pl_uomask2;
	unsigned char appinf_pl_flags;
	
	unsigned short playlength, sublength;
	unsigned char ***clipname, ***codecId;
	unsigned char *multiangle;
	unsigned char *c_condition;
	unsigned char **stcId;
	unsigned long *intime;
	unsigned long *outtime;
	unsigned long *pl_uomask;
	unsigned long *pl_uomask2;
	unsigned char *pl_RAflag;
	unsigned char *stillmode;
	unsigned short *stilltime;
	unsigned char *angleEntries;
	unsigned char *angleDiffAudio;
	unsigned char *angleSeamlessChange;
	
	unsigned char *p_vs_length;
	unsigned char *p_as_length;
	unsigned char *pgtxs_length;
	unsigned char *igs_length;
	unsigned char *s_vs_length;
	unsigned char *s_as_length;
	unsigned char *pip_pgtxs_length;
	
	unsigned char **vs_stream_t;
	unsigned int **vs_pid;
	unsigned char **vs_coding;
	unsigned char **vs_format;
	unsigned char **vs_framerate;
	
	unsigned char **as_stream_t;
	unsigned int **as_pid;
	unsigned char **as_coding;
	unsigned char **as_ptype;
	unsigned char **as_samplerate;
	unsigned char ***as_lang;
	
	unsigned char **pgtxs_stream_t;
	unsigned int **pgtxs_pid;
	unsigned char **pgtxs_coding;
	unsigned char ***pgtxs_lang;
	
	unsigned char **igs_stream_t;
	unsigned int **igs_pid;
	unsigned char **igs_coding;
	unsigned char ***igs_lang;
	
	unsigned char **s_vs_stream_t;
	unsigned int **s_vs_pid;
	unsigned char **s_vs_coding;
	unsigned char **s_vs_format;
	unsigned char **s_vs_framerate;
	unsigned int **s_vs_sa_ref_len;
	unsigned char ***s_vs_sa_ref;
	unsigned int **s_vs_pip_ref_len;
	unsigned char ***s_vs_pip_ref;
	
	unsigned char **s_as_stream_t;
	unsigned int **s_as_pid;
	unsigned char **s_as_coding;
	unsigned char **s_as_ptype;
	unsigned char **s_as_samplerate;
	unsigned char ***s_as_lang;
	unsigned int **s_as_pa_ref_len;
	unsigned char ***s_as_pa_ref;
	
	unsigned char ****sub_clipname;
	unsigned char ****sub_codecId;
	unsigned char ***sub_stcId;
	unsigned char *sub_type;
	unsigned char *sub_isrepeat;
	unsigned char *sub_length;
	unsigned char **sub_c_condition;
	unsigned char **sub_multiClip;
	unsigned char **sub_intime;
	unsigned char **sub_outtime;
	unsigned char **sub_syncPlayID;
	unsigned char **sub_startPTS;
	unsigned char **sub_clipEntries;
	
	unsigned short mark_length;
	unsigned char *mark_type;
	unsigned short *mark_idRef;
	unsigned long *mark_timestamp;
	unsigned short *mark_entry_es_pid;
	unsigned long *mark_duration;
};

struct BD_MovieData
{
	//AVCodecContext *codec[8192];
	long block;
	int packet;
	char key[16];
	long peslength[8192];
	char **m2tsStream;
	char dataf[8192];
	unsigned long pos[8192];
	char disc_root[512];
	int pids[4];
	int pli;
	
	AVFormatContext *pFormatCtx;
	AVCodecContext **pCodecCtx;
	AVFrame **pFrame;
	short **pPCM;
	AVCodec **pvCodec;
	AVCodec **paCodec;
	
	FILE *fp;
	
	char pb_status;
	struct BD_PlayList pl;
	struct SwsContext *imgConvertCtx;
};

extern void mixaudio(void*, unsigned char*, int);
int bdpb_setMovie(struct BD_MovieData*, char[], int);
int bdpb_seek(struct BD_MovieData*, unsigned long);
int bdpb_playloopf(struct BD_MovieData*);
void bdpb_playback(struct BD_MovieData*);
void bdpb_pause(struct BD_MovieData*);
void bdpb_stop(struct BD_MovieData*);
void bdpb_changeVideoTrack(struct BD_MovieData*, int);
void bdpb_changeAudioTrack(struct BD_MovieData*, int);
void bdpb_changeSubpictureTrack(struct BD_MovieData*, int);
