package beluga;


import org.apache.http.*;
import org.apache.http.client.*;
import org.apache.http.client.entity.*;
import org.apache.http.client.methods.*;
import org.apache.http.cookie.*;
import org.apache.http.impl.client.*;
import org.apache.http.message.*;
import org.apache.http.protocol.*;
import org.apache.http.util.*;

import java.io.*;
import java.util.*;


/**
 * Created by IntelliJ IDEA.
 * User: g9133
 * Date: 11/06/20
 * Time: 10:35
 * To change this template use File | Settings | File Templates.
 */
public class BelugaClient {
    private static CookieStore cookieStore = null;


    public static DefaultHttpClient getHttpClient() {
        DefaultHttpClient client = new DefaultHttpClient();

        client.setCookieStore(cookieStore);

        return client;
    }

    public static HashMap login(String e_mail, String password) throws Exception {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet           get    = new HttpGet("http://belugapods.com/login");
        HashMap           map    = new HashMap();

        try {
            HttpResponse res = client.execute(get);
            HttpEntity   ent = res.getEntity();

            System.out.println("Login form get: " + res.getStatusLine());
            EntityUtils.consume(ent);

            System.out.println("Initial set of cookies:");

            List<Cookie> cookies = client.getCookieStore().getCookies();

            if (cookies.isEmpty()) {
                System.out.println("None");
            } else {
                for (int i = 0; i < cookies.size(); i++) {
                    System.out.println("- " + cookies.get(i).toString());
                }
            }


            HttpPost httpost = new HttpPost("https://belugapods.com/login");

            List <NameValuePair> nvps = new ArrayList <NameValuePair>();

            map.put("_xsrf", cookies.get(0).getValue());

            nvps.add(new BasicNameValuePair("_xsrf"   , cookies.get(0).getValue()));
            nvps.add(new BasicNameValuePair("ident"   , e_mail));
            nvps.add(new BasicNameValuePair("password", password));

            httpost.setEntity(new UrlEncodedFormEntity(nvps, HTTP.UTF_8));

            res = client.execute(httpost);
            ent = res.getEntity();

            System.out.println("Login form get: " + res.getStatusLine());

            EntityUtils.consume(ent);

            System.out.println("Post logon cookies:");

            cookies = client.getCookieStore().getCookies();
            cookieStore = client.getCookieStore();

            if (cookies.isEmpty()) {
                System.out.println("None");
            } else {
                for (int i = 0; i < cookies.size(); i++) {
                    System.out.println("- " + cookies.get(i).toString());
                }

                if (cookies.size() < 2) {
                    return null;
                }
            }

            get = new HttpGet("http://belugapods.com/pods");
            res = client.execute(get);
            ent = res.getEntity();

            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            String         line   = "";
            ArrayList      pods   = new ArrayList();

            while ((line = reader.readLine()) != null) {
                if (line.indexOf("userimg") > -1) {
                    map.put("user_image", line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));
                    
                    reader.readLine();
                    line = reader.readLine();

                    map.put("user_name", line.replaceAll("</.*", "").replaceAll(".*>", ""));
                }
                
                if (line.indexOf("\"pod\"") > -1) {
                    PodBean pb = new PodBean();
                    
                    pb.setId(line.replaceAll("\">.*", "").replaceAll(".*\"", ""));
                    
                    reader.readLine();
                    reader.readLine();
                    line = reader.readLine();
                    
                    pb.setPodImg(line.replaceAll("\">.*", "").replaceAll(".*\"", ""));
                    
                    reader.readLine();
                    reader.readLine();
                    reader.readLine();
                    line = reader.readLine();
                    
                    pb.setPodTime(line.replaceAll("</.*", "").replaceAll(".*>", ""));

                    reader.readLine();
                    line = reader.readLine();
                    
                    pb.setPodTitle(line.replaceAll("</.*", "").replaceAll(".*>", ""));

                    line = reader.readLine();

                    if (line.indexOf("</em>") > -1) {
                        pb.setLastMessage(line.replaceAll("</.*", "").replaceAll(".*>", ""));
                    } else {
                        pb.setLastMessage(line.replaceAll(".*>", ""));
                        pb.setLastMessage(pb.getLastMessage() + System.getProperty("line.separator"));

                        do {
                            pb.setLastMessage(pb.getLastMessage() + System.getProperty("line.separator"));
                        } while (line.indexOf("</") > -1);
                    }

                    pb.setE_mail(e_mail);
                    pb.setPassword(password);
                    pods.add(pb);
                }
            }

            map.put("pods", pods.toArray(new PodBean[pods.size()]));
            map.put("client", client);

//            get = new HttpGet("http://belugapods.com/pod/4daef271e694aa4e6e011f7e");
//            res = client.execute(get);
//            ent = res.getEntity();
//
//            reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
//
//            while ((line = reader.readLine()) != null) {
//                System.out.println(line);
//            }
        } catch (Exception ex) {
            throw ex;
        }

        return map;
    }
    
    public static void check() {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet           get    = new HttpGet("http://belugapods.com/fblogin?next=");

        try {
            HttpResponse res = client.execute(get);
            HttpEntity   ent = res.getEntity();

            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            String         line   = null;
            
            boolean isForm = false;
            
            while ((line = reader.readLine()) != null) {
                String[] parce = line.split(">");
                
                for (int i = 0; i < parce.length; i++) {
                    if (parce[i].indexOf("<form") > -1) {
                        isForm = true;
                    }
                    if (isForm) {
                        if (parce[i].indexOf("input") > -1 && parce[i].indexOf("name=") > -1) {
                            
                            
                            System.out.print(parce[i].replaceAll(".*name=\"", "").replaceAll("\".*", ""));
                            System.out.print(",");
                            System.out.println(parce[i].replaceAll(".*value=\"", "").replaceAll("\".*", ""));
                        }
                    }

                    if (parce[i].indexOf("</form") > -1) {
                        isForm = false;
                    }
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        try {
            BelugaClient.check();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}
