package beluga;


import org.apache.http.*;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.*;

import javax.swing.*;
import java.awt.*;
import java.io.*;
import java.net.*;


/**
 * Created by IntelliJ IDEA.
 * User: g9133
 * Date: 11/06/23
 * Time: 14:04
 * To change this template use File | Settings | File Templates.
 */
public class PodBean {
    private String id;
    private String podImg;
    private String podTime;
    private String podTitle;
    private String lastMessage;
    private ImageIcon icon;
    private String e_mail;
    private String password;


    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPodImg() {
        return podImg;
    }

    public void setPodImg(String podImg) {
        this.podImg = podImg;
    }

    public String getPodTime() {
        return podTime;
    }

    public void setPodTime(String podTime) {
        this.podTime = podTime;
    }

    public String getPodTitle() {
        return podTitle;
    }

    public void setPodTitle(String podTitle) {
        this.podTitle = podTitle;
    }

    public String getLastMessage() {
        return lastMessage;
    }

    public void setLastMessage(String lastMessage) {
        this.lastMessage = lastMessage;
    }

    public ImageIcon getPodImgIcon(DefaultHttpClient cli) {
        if (icon == null) {
            try {
                HttpGet           get    = new HttpGet("http://belugapods.com" + getPodImg());
                HttpResponse      res    = cli.execute(get);
                HttpEntity        ent    = res.getEntity();

                BufferedInputStream   bis  = new BufferedInputStream(ent.getContent());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[]                data = new byte[512];
                int                   len  = -1;
                
                while ((len = bis.read(data, 0, data.length)) != -1) {
                    baos.write(data, 0, len);
                }

                icon = new ImageIcon(new ImageIcon(baos.toByteArray()).getImage().getScaledInstance(32, 32, Image.SCALE_SMOOTH));
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        return icon; 
    }

    public String getUrl_members() {
        return "/members/" + this.getId();
    }

    public String getUrl_updates() {
        return "/pod/" + this.getId();
    }

    public String getUrl_map() {
        return "/map/" + this.getId();
    }

    public String getUrl_edit() {
        return "/edit/" + this.getId();
    }

    public String getE_mail() {
        return e_mail;
    }

    public void setE_mail(String e_mail) {
        this.e_mail = e_mail;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}
