package beluga;


import org.apache.http.*;
import org.apache.http.client.entity.*;
import org.apache.http.client.methods.*;
import org.apache.http.impl.client.*;
import org.apache.http.message.*;
import org.apache.http.protocol.*;
import org.apache.http.util.*;

import javax.swing.*;
import javax.swing.Timer;
import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import java.util.List;


/**
 * Created by IntelliJ IDEA.
 * User: g9133
 * Date: 11/06/24
 * Time: 11:07
 * To change this template use File | Settings | File Templates.
 */
public class PodPane extends JPanel {

    private IFBelugaFrame frame = null;
    private CardLayout layout = new CardLayout();
    private JScrollPane jScrollPane_updates = new JScrollPane();
    private JScrollPane jScrollPane_members = new JScrollPane();
    private JScrollPane jScrollPane_map = new JScrollPane();
    private JScrollPane jScrollPane_edit = new JScrollPane();
    private int page_cnt = 30;
    private JPanel jPanel = null;
    private PodBean podBean = null;
    private DefaultHttpClient client = null;
    private String last_id = null;
    private String old_id = null;
    private boolean isVisible = true;


    public PodPane(IFBelugaFrame frame, PodBean podBean) {
        super();

        this.frame   = frame;
        this.podBean = podBean;
        this.client  = BelugaClient.getHttpClient();

        this.setLayout(layout);
        this.add(jScrollPane_updates, "Updates");
        this.add(jScrollPane_members, "Members");
        this.add(jScrollPane_map, "Map");
        this.add(jScrollPane_edit, "Edit");

        jScrollPane_updates.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane_updates.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane_updates.getVerticalScrollBar().setUnitIncrement(13);
        jScrollPane_members.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane_members.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane_members.getVerticalScrollBar().setUnitIncrement(13);

        this.podBean.getPodImgIcon(client);
        
        PodRowBean[] prbs = getMembers();

        JPanel jPanel_members = new JPanel(new GridLayout(prbs.length, 0));

        for (PodRowBean prb : prbs) {
            jPanel_members.add(new PodRow(PodPane.this.frame, prb));
        }

        jScrollPane_members.getViewport().setView(jPanel_members);

        try {
            JEditorPane jEditorPane = new JEditorPane("text/html", getMap());

            jEditorPane.setEditable(false);

            jScrollPane_map.getViewport().setView(jEditorPane);
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        jScrollPane_edit.getViewport().setView(new EditorPane(podBean));

        refreshPod();

        Timer timer = new Timer(5000, new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                new Thread() {
                    public void run() {
                        refreshPod();
                    }
                }.start();

                if (String.valueOf(Runtime.getRuntime().freeMemory()).length() > 6) {
                    System.out.print(String.valueOf(Runtime.getRuntime().freeMemory() / 1000000) + "MB");
                } else if (String.valueOf(Runtime.getRuntime().freeMemory()).length() > 3) {
                    System.out.print(String.valueOf(Runtime.getRuntime().freeMemory() / 1000) + "KB");
                } else {
                    System.out.print(String.valueOf(Runtime.getRuntime().freeMemory()) + "B");
                }

                System.out.print("/");

                if (String.valueOf(Runtime.getRuntime().totalMemory()).length() > 6) {
                    System.out.print(String.valueOf(Runtime.getRuntime().totalMemory() / 1000000) + "MB");
                } else if (String.valueOf(Runtime.getRuntime().totalMemory()).length() > 3) {
                    System.out.print(String.valueOf(Runtime.getRuntime().totalMemory() / 1000) + "KB");
                } else {
                    System.out.print(String.valueOf(Runtime.getRuntime().totalMemory()) + "B");
                }

                System.out.println();
            }
        });

        timer.setInitialDelay(5000);
        timer.setRepeats(true);
        timer.start();
    }
    
    public PodBean getPodBean() {
        return podBean;
    }

    public void show(String cmd) {
        layout.show(this, cmd);
    }

    public void send(String message) throws Exception {
        HttpPost            post   = new HttpPost("http://belugapods.com/update");
        List<NameValuePair> nvps   = new ArrayList <NameValuePair>();

        nvps.add(new BasicNameValuePair("_xsrf"        , client.getCookieStore().getCookies().get(0).getValue()));
        nvps.add(new BasicNameValuePair("source"       , "mobile"));
        nvps.add(new BasicNameValuePair("podid"        , podBean.getId()));
        nvps.add(new BasicNameValuePair("text"         , message));
        nvps.add(new BasicNameValuePair("composebutton", "Send"));

        post.setEntity(new UrlEncodedFormEntity(nvps, HTTP.UTF_8));

        EntityUtils.consume(BelugaClient.getHttpClient().execute(post).getEntity());

        updatePod();
    }

    public void updatePod() {
        last_id = "";

        try {
            if (jScrollPane_updates.getVerticalScrollBar().getValue() > 100) {
                int unit = jScrollPane_updates.getVerticalScrollBar().getValue() / 50;

                for (int i = jScrollPane_updates.getVerticalScrollBar().getValue(); i > 0; i -= unit) {
                    jScrollPane_updates.getVerticalScrollBar().setValue(jScrollPane_updates.getVerticalScrollBar().getValue() - unit);

                    Thread.sleep(15);
                }
            } else {
                Thread.sleep(500);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        new Thread() {
            public void run() {
                refreshPod(page_cnt = 30, 0, false);
            }
        }.start();
    }

    public void refreshPod() {
        refreshPod(0, 1, false);
    }

    public void refreshPod(int count, int verticals, boolean isForce) {
        PodRow[] rows = getNewPodRows(isForce);

        if (rows == null || rows.length < 1) {
            return;
        }

        final int vertical = verticals == 0 ? 0 : jScrollPane_updates.getVerticalScrollBar().getValue();

        page_cnt = count == 0 ? page_cnt : count;

        JPanel   jPanel2 = new JPanel(new GridLayout(page_cnt + 1, 0));

        for (int i = 0; i < rows.length; i++) {
            jPanel2.add(rows[i]);
        }

        JButton jButton_next = new JButton("Load More");

        jButton_next.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                page_cnt += 30;

                refreshPod(0, 1, true);
            }
        });

        jPanel2.add(jButton_next);

        jPanel = jPanel2;

        jScrollPane_updates.getViewport().setView(jPanel);
        jScrollPane_updates.getVerticalScrollBar().setValue(vertical);

        try {
            this.updateUI();
        } catch (NullPointerException ex) {}
    }

    public ImageIcon getPodImage() {
        return podBean.getPodImgIcon(client);
    }

    private PodRow[] getNewPodRows() {
        return getNewPodRows(false);
    }

    private PodRow[] getNewPodRows(boolean isForce) {
        ArrayList<PodRow> list = new ArrayList<PodRow>();

        synchronized (podBean.getId()) {
            try {
                HttpGet        get  = new HttpGet("http://belugapods.com/pod/" + podBean.getId() + "?n=" + page_cnt);
                HttpResponse   res  = BelugaClient.getHttpClient().execute(get);
                HttpEntity     ent  = res.getEntity();

                BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
                String         line   = null;
                boolean        renew  = false;

                while ((line = reader.readLine()) != null) {
                    if (line.indexOf("a name") > -1) {
                        if (last_id != null && last_id.equals(line.replaceAll("\">.*", "").replaceAll(".*\"", ""))) {
                            if (!isForce) {
                                break;
                            }
                        } else {
                            if (!renew) {
                                last_id = line.replaceAll("\">.*", "").replaceAll(".*\"", "");
                            }

                            renew = true;
                        }

                        PodRow pr = new PodRow(frame, podBean, reader, line);

                        if (pr.getPodRowBean().getMessage().length() < 1) {
                            continue;
                        }

                        pr.setVisibleIcon(isVisible);

                        list.add(pr);
                    }
                }

                if (renew) {
                    PodRowBean podRowBean = list.get(0).getPodRowBean();

                    if (!podRowBean.getUname().equals(frame.getConstantMap().get("user_name"))) {
                        frame.displayMessage(podRowBean.getUname() + ":" + podBean.getPodTitle(), podRowBean.getMessage().replaceAll("<br>", System.getProperty("line.separator")), TrayIcon.MessageType.INFO);
                    }
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        return list.toArray(new PodRow[list.size()]);
    }

    public PodRow[] getPodRows() {
        if (jScrollPane_updates.getViewport().getView() == null) {
            return null;
        }

        ArrayList list = new ArrayList(Arrays.asList(jPanel.getComponents()));

        list.remove(list.size() - 1);

        return (PodRow[]) list.toArray(new PodRow[list.size()]);
    }

    public void setVisibleIcon(boolean isVisible) {
        this.isVisible = isVisible;

        PodRow[] podRow = getPodRows();

        if (podRow != null) {
            for (PodRow pr : podRow) {
                pr.setVisibleIcon(isVisible);
            }

            this.updateUI();
        }

        podRow = getMemberRows();

        if (podRow != null) {
            for (PodRow pr : podRow) {
                pr.setVisibleIcon(isVisible);
            }

            this.updateUI();
        }
    }


    private PodRowBean[] getMembers() {
        ArrayList<PodRowBean> list = new ArrayList<PodRowBean>();

        try {
            HttpGet        get  = new HttpGet("http://belugapods.com/members/" + podBean.getId());
            HttpResponse   res  = BelugaClient.getHttpClient().execute(get);
            HttpEntity     ent  = res.getEntity();

            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            String         line   = null;

            while ((line = reader.readLine()) != null) {
                PodRowBean prb = new PodRowBean();

                try {
                    while ((line = reader.readLine()).indexOf("update") < 0);
                } catch (Exception ex) {
                    break;
                }

                reader.readLine();
                
                line = reader.readLine();

                prb.setUserimg(line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));

                while ((line = reader.readLine()).indexOf("mname") < 0);

                prb.setUname(line.replaceAll("</.*", "").replaceAll(".*>", ""));

                while ((line = reader.readLine()).indexOf("utext") < 0);

                prb.setMessage(line.replaceAll("</span.*", "").replaceAll(".*utext\">", ""));

                if (prb.getUserimg() == null || prb.getUname() == null || prb.getMessage() == null) {
                    continue;
                }

                list.add(prb);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return list.toArray(new PodRowBean[list.size()]);
    }

    private PodRow[] getMemberRows() {
        if (jScrollPane_members.getViewport().getView() == null) {
            return null;
        }

        ArrayList list = new ArrayList(Arrays.asList(((JPanel) jScrollPane_members.getViewport().getView()).getComponents()));

        return (PodRow[]) list.toArray(new PodRow[list.size()]);
    }
    
    private String getMap() {
        StringBuffer sb = new StringBuffer();

        try {
            HttpGet        get  = new HttpGet("http://belugapods.com/map/" + podBean.getId());
            HttpResponse   res  = BelugaClient.getHttpClient().execute(get);
            HttpEntity     ent  = res.getEntity();

            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            
            String         line   = null;

            while ((line = reader.readLine()) != null) {
                sb.append(line).append(System.getProperty("line.separator"));
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return sb.toString();
    }
}
