/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * PodRow.java
 *
 * Created on 2011/06/23, 19:03:51
 */

package beluga;


import org.apache.http.*;
import org.apache.http.client.methods.*;

import javax.swing.*;
import java.awt.*;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.*;
import java.awt.font.*;
import java.io.*;
import java.net.*;
import java.util.*;


/**
 *
 * @author g9133
 */
public class PodRow extends javax.swing.JPanel {
    private IFBelugaFrame frame      = null;
    private PodRowBean    podRowBean = new PodRowBean(); 

    private PodRow() {
        initComponents();
    }

    /** Creates new form PodRow */
    public PodRow(IFBelugaFrame frame, PodBean podBean, BufferedReader reader, String line) {
        this();

        this.frame = frame;

        try {
            initialize(podBean, reader, line);

            displayInitialize();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PodRow(IFBelugaFrame frame, PodRowBean podRowBean) {
        this();

        this.frame      = frame;
        this.podRowBean = podRowBean;

        try {
            displayInitialize();
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    
    private void initialize(PodBean pb, BufferedReader reader, String line) throws Exception {
        podRowBean.setId(line.replaceAll("\">.*", "").replaceAll(".*\"", ""));

        while ((line = reader.readLine()).indexOf("userimg") < 0);
        
        podRowBean.setUserimg(line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));

        while ((line = reader.readLine()).indexOf("utitle") < 0);

        line = reader.readLine();

        podRowBean.setUtitle(line.replaceAll("\"></", "").replaceAll(".*\"", ""));

        while ((line = reader.readLine()).indexOf("uname") < 0);

        line = reader.readLine();

        podRowBean.setDetails(line.replaceAll("\">.*", "").replaceAll(".*\"", ""));
        podRowBean.setUname(line.replaceAll("</.*", "").replaceAll(".*>", ""));

        while (true) {
            line = reader.readLine();

            if (line.indexOf("uimg") < 0 && line.indexOf("upin") < 0 && line.indexOf("utime") < 0) {
                continue;
            }
            
            if (line.indexOf("uimg") > -1) {
                podRowBean.setUimg(line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));
            }
    
            if (line.indexOf("upin") > -1) {
                podRowBean.setUpin(line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));
            }
    
            if (line.indexOf("utime") > -1) {
                podRowBean.setUtime(getPodTime(line.replaceAll("</.*", "").replaceAll(".*>", "")));
                break;
            }
        }

        while ((line = reader.readLine()).indexOf("utext") < 0);

        podRowBean.setMessage(line.replaceAll("</span.*", "").replaceAll(".*utext\">", ""));
    }
    
    private void displayInitialize() {
        jLabel_uimg.setIcon(getImageIcon(podRowBean.getUimg(), 16));
        jLabel_podtime.setIcon(getImageIcon(podRowBean.getUpin(), 16));
        jLabel_icon.setIcon(getImageIcon(podRowBean.getUserimg(), 50));
        jLabel_user_name.setText(podRowBean.getUname());
        
        if (podRowBean.getUtime() != null) {
            jLabel_podtime.setText(podRowBean.getUtime());

            TextLayout tl = new TextLayout(podRowBean.getUtime(), jLabel_podtime.getFont(), ((Graphics2D) ((JFrame) frame).getGraphics()).getFontRenderContext());

            jLabel_podtime.setPreferredSize(new Dimension((int) tl.getAdvance() + (jLabel_podtime.getIcon() != null ? 22 : 0) , 19));
        }

        jLabel_message.setText("<html>" + podRowBean.getMessage() + "</html>");

        if (podRowBean.getMessage().split("<br>").length > 2) {
            jLabel_message.setPreferredSize(new Dimension(jLabel_message.getPreferredSize().width, jLabel_message.getPreferredSize().height + ((podRowBean.getMessage().split("<br>").length - 2) * 14)));
            jLabel_message.setMaximumSize  (jLabel_message.getPreferredSize());
            jLabel_message.setMinimumSize  (jLabel_message.getPreferredSize());

            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height + ((podRowBean.getMessage().split("<br>").length - 2) * 14)));
            this.setMaximumSize  (this.getPreferredSize());
            this.setMinimumSize  (this.getPreferredSize());
        }

        if (podRowBean.getMessage().indexOf("<a") > -1) {
            jLabel_message.putClientProperty("url", podRowBean.getMessage().replaceAll(".*href=\"", "").replaceAll("\".+", ""));
        }

        if (podRowBean.getUimg() != null || podRowBean.getUpin() != null) {
            new Thread() {
                public void run() {
                    casheDetail();
                }
            }.start();
        }
    }

    private String getPodTime(String line) {
        return line.replaceAll("</.*", "").replaceAll(".*>", "").
                    replaceAll("just now", "").
                    replaceAll("sec", "b").replaceAll("min", "").replaceAll("hr", "").replaceAll("yesterday", "").
                    replaceAll("Jan ", "1/").replaceAll("Feb ", "2/").replaceAll("Mar ", "3/").replaceAll("Apr ",  "4/").replaceAll("May ",  "5/").replaceAll("Jun ",  "6/").
                    replaceAll("Jul ", "7/").replaceAll("Aug ", "8/").replaceAll("Sep ", "9/").replaceAll("Oct ", "10/").replaceAll("Nov ", "11/").replaceAll("Dec ", "12/");
    }

    public ImageIcon getImageIcon(String uri, int size) {
        if (uri == null) {
            return null;
        }
        
        if (!frame.getImageMap().containsKey(uri)) {
            frame.getImageMap().put(uri, new ImageIcon(new ImageIcon(getImage(uri)).getImage().getScaledInstance(size, size, Image.SCALE_SMOOTH)));
        }

        return (ImageIcon) frame.getImageMap().get(uri);
    }

    private byte[] getImage(String uri) {
        return getImage(uri, false);
    }

    private byte[] getImage(String uri, boolean isGoogle) {
        if (uri == null) {
            return null;
        }

        try {
            HttpGet      get = new HttpGet(isGoogle ? uri : "http://belugapods.com" + uri);
            HttpResponse res = BelugaClient.getHttpClient().execute(get);
            HttpEntity   ent = res.getEntity();

            BufferedInputStream   bis  = new BufferedInputStream(ent.getContent());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[]                data = new byte[4096];
            int                   len  = -1;

            while ((len = bis.read(data, 0, data.length)) != -1) {
                baos.write(data, 0, len);
            }

            return baos.toByteArray();
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        return null;
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPopupMenu = new javax.swing.JPopupMenu();
        jMenuItem_copy = new javax.swing.JMenuItem();
        jMenuItem_reply = new javax.swing.JMenuItem();
        jMenuItem_quote_reply = new javax.swing.JMenuItem();
        jPanel_center = new javax.swing.JPanel();
        jLabel_space1 = new javax.swing.JLabel();
        jPanel_left = new javax.swing.JPanel();
        jPanel_top = new javax.swing.JPanel();
        jLabel_user_name = new javax.swing.JLabel();
        jPanel_center2 = new javax.swing.JPanel();
        jLabel_uimg = new javax.swing.JLabel();
        jLabel_podtime = new javax.swing.JLabel();
        jLabel_message = new javax.swing.JLabel();
        jLabel_space2 = new javax.swing.JLabel();
        jPanel_west = new javax.swing.JPanel();
        jLabel_icon = new javax.swing.JLabel();

        jMenuItem_copy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem_copy.setMnemonic('C');
        jMenuItem_copy.setText("Copy");
        jMenuItem_copy.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_copyActionPerformed(evt);
            }
        });
        jPopupMenu.add(jMenuItem_copy);

        jMenuItem_reply.setText("Reply");
        jMenuItem_reply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_replyActionPerformed(evt);
            }
        });
        jPopupMenu.add(jMenuItem_reply);

        jMenuItem_quote_reply.setText("Quote Reply");
        jMenuItem_quote_reply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem_quote_replyActionPerformed(evt);
            }
        });
        jPopupMenu.add(jMenuItem_quote_reply);

        setBackground(java.awt.Color.white);
        setBorder(javax.swing.BorderFactory.createLineBorder(java.awt.SystemColor.control));
        setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        setMinimumSize(new java.awt.Dimension(100, 50));
        setPreferredSize(new java.awt.Dimension(190, 50));
        setLayout(new java.awt.BorderLayout());

        jPanel_center.setMinimumSize(new java.awt.Dimension(200, 50));
        jPanel_center.setOpaque(false);
        jPanel_center.setPreferredSize(new java.awt.Dimension(200, 50));
        jPanel_center.setLayout(new java.awt.BorderLayout());

        jLabel_space1.setMaximumSize(new java.awt.Dimension(5, 0));
        jLabel_space1.setMinimumSize(new java.awt.Dimension(5, 0));
        jLabel_space1.setPreferredSize(new java.awt.Dimension(5, 0));
        jPanel_center.add(jLabel_space1, java.awt.BorderLayout.WEST);

        jPanel_left.setOpaque(false);
        jPanel_left.setLayout(new java.awt.BorderLayout());

        jPanel_top.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jPanel_top.setMinimumSize(new java.awt.Dimension(140, 19));
        jPanel_top.setOpaque(false);
        jPanel_top.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                formMouseClicked(evt);
            }
        });
        jPanel_top.setLayout(new java.awt.BorderLayout());

        jLabel_user_name.setFont(new java.awt.Font("MS UI Gothic", 1, 12));
        jLabel_user_name.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        jLabel_user_name.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jLabel_user_name.setMaximumSize(new java.awt.Dimension(200, 19));
        jLabel_user_name.setMinimumSize(new java.awt.Dimension(100, 19));
        jLabel_user_name.setPreferredSize(new java.awt.Dimension(100, 19));
        jLabel_user_name.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                formMouseClicked(evt);
            }
        });
        jPanel_top.add(jLabel_user_name, java.awt.BorderLayout.CENTER);

        jPanel_center2.setOpaque(false);
        jPanel_center2.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT, 0, 0));

        jLabel_uimg.setMaximumSize(new java.awt.Dimension(19, 19));
        jLabel_uimg.setMinimumSize(new java.awt.Dimension(19, 19));
        jLabel_uimg.setPreferredSize(new java.awt.Dimension(19, 19));
        jLabel_uimg.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel_uimgMouseClicked(evt);
            }
        });
        jPanel_center2.add(jLabel_uimg);

        jLabel_podtime.setForeground(new java.awt.Color(102, 102, 102));
        jLabel_podtime.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jLabel_podtime.setMaximumSize(new java.awt.Dimension(200, 19));
        jLabel_podtime.setMinimumSize(new java.awt.Dimension(19, 19));
        jLabel_podtime.setPreferredSize(new java.awt.Dimension(19, 19));
        jLabel_podtime.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel_podtimeMouseClicked(evt);
            }
        });
        jPanel_center2.add(jLabel_podtime);

        jPanel_top.add(jPanel_center2, java.awt.BorderLayout.EAST);

        jPanel_left.add(jPanel_top, java.awt.BorderLayout.NORTH);

        jLabel_message.setMaximumSize(new java.awt.Dimension(32767, 32767));
        jLabel_message.setMinimumSize(new java.awt.Dimension(140, 31));
        jLabel_message.setPreferredSize(new java.awt.Dimension(140, 31));
        jLabel_message.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jLabel_messageMouseReleased(evt);
                formMouseClicked(evt);
            }
        });
        jPanel_left.add(jLabel_message, java.awt.BorderLayout.CENTER);

        jLabel_space2.setMaximumSize(new java.awt.Dimension(5, 0));
        jLabel_space2.setMinimumSize(new java.awt.Dimension(5, 0));
        jLabel_space2.setPreferredSize(new java.awt.Dimension(5, 0));
        jPanel_left.add(jLabel_space2, java.awt.BorderLayout.WEST);

        jPanel_center.add(jPanel_left, java.awt.BorderLayout.CENTER);

        add(jPanel_center, java.awt.BorderLayout.CENTER);

        jPanel_west.setBackground(new java.awt.Color(255, 255, 255));
        jPanel_west.setMaximumSize(new java.awt.Dimension(500, 500));
        jPanel_west.setMinimumSize(new java.awt.Dimension(50, 50));
        jPanel_west.setPreferredSize(new java.awt.Dimension(50, 50));
        jPanel_west.setLayout(new java.awt.GridBagLayout());

        jLabel_icon.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED));
        jLabel_icon.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        jLabel_icon.setMaximumSize(new java.awt.Dimension(50, 50));
        jLabel_icon.setMinimumSize(new java.awt.Dimension(50, 50));
        jLabel_icon.setPreferredSize(new java.awt.Dimension(50, 50));
        jLabel_icon.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel_iconMouseClicked(evt);
            }
        });
        jPanel_west.add(jLabel_icon, new java.awt.GridBagConstraints());

        add(jPanel_west, java.awt.BorderLayout.WEST);
    }// </editor-fold>//GEN-END:initComponents

    private void formMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_mouseClicked
        JPanel jPanel = (JPanel) SwingUtilities.getAncestorOfClass(JPanel.class, this);
        
        for (int i = 0; i < jPanel.getComponentCount(); i++) {
            if (jPanel.getComponent(i) instanceof PodRow) {
                ((PodRow) jPanel.getComponent(i)).setBorder(BorderFactory.createLineBorder(SystemColor.control));
            }
        }
        
        this.setBorder(BorderFactory.createLineBorder(Color.gray, 2));
        
    }//GEN-LAST:event_mouseClicked

    private void jLabel_uimgMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel_uimgMouseClicked
        if (((JLabel) evt.getComponent()).getIcon() == null) {
            return;
        }

        showPreviewDialog(evt, podRowBean.getDetailImg(), false);
    }//GEN-LAST:event_jLabel_uimgMouseClicked

    private void jLabel_podtimeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel_podtimeMouseClicked
        if (((JLabel) evt.getComponent()).getIcon() == null) {
            return;
        }

        showPreviewDialog(evt, podRowBean.getDetailMap(), true);
    }//GEN-LAST:event_jLabel_podtimeMouseClicked

    private void jLabel_messageMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel_messageMouseReleased
        if (evt.isPopupTrigger()) {
            jPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            return;
        }

        if (jLabel_message.getClientProperty("url") == null) {
            return;
        }

        try {
            Desktop.getDesktop().browse(new URI((String) jLabel_message.getClientProperty("url")));
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }//GEN-LAST:event_jLabel_messageMouseReleased

    private void jMenuItem_copyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_copyActionPerformed
        Clipboard       cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection ss = new StringSelection(jLabel_message.getText().replaceAll("</?html>", "").replaceAll("<br>", System.getProperty("line.separator")));

        cb.setContents(ss, null);
    }//GEN-LAST:event_jMenuItem_copyActionPerformed

    private void jLabel_iconMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel_iconMouseClicked
        showPreviewDialog(evt, podRowBean.getUserimg(), false);
    }//GEN-LAST:event_jLabel_iconMouseClicked

    private void jMenuItem_replyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_replyActionPerformed
        frame.setMessage("@" + podRowBean.getUname() + " ");
    }//GEN-LAST:event_jMenuItem_replyActionPerformed

    private void jMenuItem_quote_replyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem_quote_replyActionPerformed
        frame.setMessage("QT@" + podRowBean.getUname() + " " + podRowBean.getMessage(), true);
    }//GEN-LAST:event_jMenuItem_quote_replyActionPerformed

    public void setVisibleIcon(boolean isVisible) {
        if (isVisible) {
            this.add(jPanel_west, "West");
        } else {
            this.remove(jPanel_west);
        }
    }

    private void casheDetail() {
        try {
            HttpGet      get = new HttpGet("http://belugapods.com" + podRowBean.getDetails());
            HttpResponse res = BelugaClient.getHttpClient().execute(get);
            HttpEntity   ent = res.getEntity();
                
            BufferedReader reader = new BufferedReader(new InputStreamReader(ent.getContent(), "UTF8"));
            String         line   = null;
            
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("detailimg") > -1) {
                    podRowBean.setDetailImg(line.replaceAll("\"/>.*", "").replaceAll(".*\"", ""));
                }

                if (line.indexOf("staticmap") > -1) {
                    podRowBean.setDetailMap(line.replaceAll(".*src=\"", "").replaceAll("\".*", ""));
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void showPreviewDialog(MouseEvent evt, final String uri, final boolean isGoogle) {
        if (getImageMap().containsKey(uri)) {
            return;
        }

        final JDialog jDialog   = new JDialog((JFrame) frame);
        ImageIcon     imageIcon = new ImageIcon(getImage(uri, isGoogle));
        final JLabel  jLabel    = new JLabel();

        jDialog.setUndecorated(true);
        jDialog.addWindowListener(new WindowAdapter() {
            @Override
            public void windowClosed(WindowEvent e) {
                getImageMap().remove(uri);
            }
        });

        jDialog.addComponentListener(new ComponentAdapter() {
            @Override
            public void componentMoved(ComponentEvent e) {
                if (jLabel.getClientProperty("window") == null) {
                    return;
                }

                JWindow jWindow = (JWindow) jLabel.getClientProperty("window");
                
                jWindow.setLocation(jDialog.getLocationOnScreen().x + jDialog.getWidth() - jWindow.getWidth() - 2, jDialog.getLocationOnScreen().y + jDialog.getHeight() - jWindow.getHeight() - 2);
            }
        });
            
        int width  = imageIcon.getImage().getWidth (imageIcon.getImageObserver());
        int height = imageIcon.getImage().getHeight(imageIcon.getImageObserver());

        if (!isGoogle) {
            while (width > 320 || height > 240) {
                width  = width  / 2;
                height = height / 2;
            }

            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(width, height, Image.SCALE_SMOOTH));
        }

        jLabel.setIcon(imageIcon);
        jDialog.setSize(width, height);

        int x = evt.getComponent().getLocationOnScreen().x + evt.getX();
        int y = evt.getComponent().getLocationOnScreen().y + evt.getY();

        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();


        if (x + jDialog.getWidth() > dim.getWidth()) {
            x = ((int) dim.getWidth()) - jDialog.getWidth();
        }

        if (y + jDialog.getHeight() > dim.getHeight()) {
            y = ((int) dim.getHeight()) - jDialog.getHeight();
        }

        jDialog.setLocation(x, y);

        jLabel.setBorder(BorderFactory.createEtchedBorder());
        jLabel.setToolTipText("Double Click to close");

        jLabel.addMouseListener(new MouseAdapter() {
            @Override
            public void mousePressed(MouseEvent e) {
                jLabel.putClientProperty("loc1", jDialog.getLocationOnScreen());
                jLabel.putClientProperty("loc2", MouseInfo.getPointerInfo().getLocation());

                jLabel.setBorder(BorderFactory.createLineBorder(Color.gray, 2));

                if (e.getButton() == e.BUTTON1 && e.getClickCount() == 2) {
                    jDialog.dispose();
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                jLabel.setBorder(BorderFactory.createEtchedBorder());
            }
        });

        jLabel.addMouseMotionListener(new MouseMotionAdapter() {
            @Override
            public void mouseDragged(MouseEvent e) {
                Point loc1 = (Point) jLabel.getClientProperty("loc1");
                Point loc2 = (Point) jLabel.getClientProperty("loc2");
                Point loc3 = MouseInfo.getPointerInfo().getLocation();

                jDialog.setLocation(loc1.x + loc3.x - loc2.x, loc1.y + loc3.y - loc2.y);
            }
        });

        jDialog.getContentPane().add(jLabel, "Center");
        jDialog.setVisible(true);

        final JPopupMenu jPopupMenu      = new JPopupMenu();
        JMenuItem        jMenuItem_org   = new JMenuItem("Original Size");
        JMenuItem        jMenuItem_tobig = new JMenuItem("Size (+)");
        JMenuItem        jMenuItem_tosml = new JMenuItem("Size (-)");
        JMenuItem        jMenuItem_close = new JMenuItem("Close");

        if (isGoogle) {
            final JMenuItem jMenuItem_type = new JMenuItem("Type to Satellite");

            jMenuItem_type.setEnabled(false);
            jMenuItem_type.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent e) {
                    if (jLabel.getClientProperty("type") == null) {
                        return;
                    }

                    if ("map_r_".equals(jLabel.getClientProperty("type"))) {
                        jLabel.putClientProperty("type", "map_s_");
                        jMenuItem_type.setText("Type to Roadmap");
                    } else {
                        jLabel.putClientProperty("type", "map_r_");
                        jMenuItem_type.setText("Type to Satellite");
                    }

                    jLabel.setIcon(new ImageIcon(new ImageIcon((byte[]) jLabel.getClientProperty(((String) jLabel.getClientProperty("type")) + jLabel.getClientProperty("zoom"))).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                }
            });

                    
            jLabel.putClientProperty("menu", jMenuItem_type);
            jPopupMenu.add(jMenuItem_type);
        }

        jMenuItem_org.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                ImageIcon icon = null;
                
                if (isGoogle) {
                    icon = new ImageIcon((byte[]) jLabel.getClientProperty(((String) jLabel.getClientProperty("type")) + jLabel.getClientProperty("zoom")));
                } else {
                    icon = new ImageIcon(getImage(uri, isGoogle)); 
                }

                jDialog.setSize(icon.getIconWidth(), icon.getIconHeight());
                jLabel.setIcon(icon);
            }
        });

        jMenuItem_tobig.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension dim = jDialog.getSize();

                if (dim.width * 2 > Toolkit.getDefaultToolkit().getScreenSize().width) {
                    return;
                }

                jDialog.setSize(dim.width * 2, dim.height * 2);

                if (isGoogle) {
                    jLabel.setIcon(new ImageIcon(new ImageIcon((byte[]) jLabel.getClientProperty(((String) jLabel.getClientProperty("type")) + jLabel.getClientProperty("zoom"))).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                } else {
                    jLabel.setIcon(new ImageIcon(new ImageIcon(getImage(uri, isGoogle)).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                }
            }
        });
        jMenuItem_tosml.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension dim = jDialog.getSize();

                if (dim.width / 2 < 50) {
                    return;
                }

                jDialog.setSize(dim.width / 2, dim.height / 2);

                if (isGoogle) {
                    jLabel.setIcon(new ImageIcon(new ImageIcon((byte[]) jLabel.getClientProperty(((String) jLabel.getClientProperty("type")) + jLabel.getClientProperty("zoom"))).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                } else {
                    jLabel.setIcon(new ImageIcon(new ImageIcon(getImage(uri, isGoogle)).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                }
            }
        });
        jMenuItem_close.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                jDialog.dispose();
            }
        });

        jPopupMenu.add(jMenuItem_org);
        jPopupMenu.add(jMenuItem_tobig);
        jPopupMenu.add(jMenuItem_tosml);
        jPopupMenu.add(new JSeparator());
        jPopupMenu.add(jMenuItem_close);

        jLabel.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    return;
                }

                jPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });

        if (isGoogle) {
            new Thread() {
                public void run() {
                    final JWindow jWindow = new JWindow(jDialog);
                    final JLabel  jLabel2 = new JLabel("  Map Loading  ");

                    jLabel.putClientProperty("window", jWindow);

                    jLabel2.setBorder(BorderFactory.createEtchedBorder());
                    jLabel2.setFont(new Font(jLabel2.getFont().getFamily(), Font.BOLD, jLabel2.getFont().getSize()));
                    jLabel2.setForeground(Color.darkGray);
                    
                    jWindow.getContentPane().add(jLabel2, "Center");
                    jWindow.pack();
                    jWindow.setLocation(jDialog.getLocationOnScreen().x + jDialog.getWidth() - jWindow.getWidth() - 2, jDialog.getLocationOnScreen().y + jDialog.getHeight() - jWindow.getHeight() - 2);
                    jWindow.setVisible(true);
                    
                    for (int i = 11; i < 20; i++) {
                        jLabel.putClientProperty("map_r_" + i, getImage(uri.replaceAll("zoom=\\d\\d", "zoom=" + i), isGoogle));
                        jLabel2.setForeground(Color.white);
                        jLabel.putClientProperty("map_s_" + i, getImage(uri.replaceAll("zoom=\\d\\d", "zoom=" + i) + "&maptype=satellite", isGoogle));
                        jLabel2.setForeground(Color.darkGray);
                    }
    
                    if (jLabel.getClientProperty("menu") != null) {
                        ((JMenuItem) jLabel.getClientProperty("menu")).setEnabled(true);
                    }

                    jLabel.putClientProperty("zoom", "15");
                    jLabel.putClientProperty("type", "map_r_");
    
                    jLabel.addMouseWheelListener(new MouseWheelListener() {
                        @Override
                        public void mouseWheelMoved(MouseWheelEvent e) {
                            String zoom = (String) jLabel.getClientProperty("zoom");
    
                            if (zoom == null) {
                                return;
                            }
    
                            int cnt = Integer.parseInt(zoom);
    
                            if (cnt + e.getWheelRotation() < 11 || cnt + e.getWheelRotation() > 19) {
                                return;
                            }
    
                            cnt += e.getWheelRotation();

                            jLabel.putClientProperty("zoom", String.valueOf(cnt));
                            jLabel.setIcon(new ImageIcon(new ImageIcon((byte[]) jLabel.getClientProperty(((String) jLabel.getClientProperty("type")) + cnt)).getImage().getScaledInstance(jDialog.getWidth(), jDialog.getHeight(), Image.SCALE_SMOOTH)));
                        }
                    });
                    
                    jWindow.setVisible(false);
                    jLabel.putClientProperty("window", null);
                }
            }.start();
        }

        getImageMap().put(uri, jDialog);
    }

    private HashMap getImageMap() {
        if (frame.getStatusBar().getClientProperty("image_cache") == null) {
            frame.getStatusBar().putClientProperty("image_cache", new HashMap());
        }
        
        return (HashMap) frame.getStatusBar().getClientProperty("image_cache");
    }

    public PodRowBean getPodRowBean() {
        return podRowBean;
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel_icon;
    private javax.swing.JLabel jLabel_message;
    private javax.swing.JLabel jLabel_podtime;
    private javax.swing.JLabel jLabel_space1;
    private javax.swing.JLabel jLabel_space2;
    private javax.swing.JLabel jLabel_uimg;
    private javax.swing.JLabel jLabel_user_name;
    private javax.swing.JMenuItem jMenuItem_copy;
    private javax.swing.JMenuItem jMenuItem_quote_reply;
    private javax.swing.JMenuItem jMenuItem_reply;
    private javax.swing.JPanel jPanel_center;
    private javax.swing.JPanel jPanel_center2;
    private javax.swing.JPanel jPanel_left;
    private javax.swing.JPanel jPanel_top;
    private javax.swing.JPanel jPanel_west;
    private javax.swing.JPopupMenu jPopupMenu;
    // End of variables declaration//GEN-END:variables
}
