/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.StarDict;
import org.omegat.gui.dictionaries.DictionariesTextArea;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionariesManager
implements DirectoryMonitor.Callback {
    protected DirectoryMonitor monitor;
    protected final Map<String, DictionaryInfo> infos = new TreeMap<String, DictionaryInfo>();
    private final DictionariesTextArea pane;
    protected static String DICTIONARY_SUBDIR = "dictionary";
    protected final Set<String> ignoreWords = new TreeSet<String>();

    public DictionariesManager(DictionariesTextArea dictionariesTextArea) {
        this.pane = dictionariesTextArea;
    }

    public void start(String string) {
        File file = new File(string);
        this.monitor = new DirectoryMonitor(file, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        DictionariesManager dictionariesManager = this;
        synchronized (dictionariesManager) {
            this.infos.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        String string = file.getPath();
        Object object = this;
        synchronized (object) {
            this.infos.remove(string);
        }
        if (file.exists()) {
            if (file.getName().equals("ignore.txt")) {
                try {
                    this.loadIgnoreWords(file);
                }
                catch (Exception exception) {
                    Log.log("Error load ignore words:" + exception.getMessage());
                }
            } else if (string.endsWith(".ifo")) {
                try {
                    object = new StarDict(file);
                    Map<String, Object> map = object.readHeader();
                    DictionariesManager dictionariesManager = this;
                    synchronized (dictionariesManager) {
                        this.infos.put(string, new DictionaryInfo((IDictionary)object, map));
                    }
                    Log.log("Loaded dictionary from " + string);
                }
                catch (Exception exception) {
                    Log.log("Error load dictionary: " + exception.getMessage());
                }
            }
        }
        this.pane.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIgnoreWords(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            Set<String> set = this.ignoreWords;
            synchronized (set) {
                String string;
                this.ignoreWords.clear();
                while ((string = bufferedReader.readLine()) != null) {
                    this.ignoreWords.add(string.trim());
                }
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreWord(String string) {
        try {
            File file = new File(this.monitor.getDir(), "ignore.txt");
            File file2 = new File(this.monitor.getDir(), "ignore.txt.new");
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "UTF-8"));
            try {
                Set<String> set = this.ignoreWords;
                synchronized (set) {
                    this.ignoreWords.add(string);
                    for (String string2 : this.ignoreWords) {
                        bufferedWriter.write(string2 + System.getProperty("line.separator"));
                    }
                }
                bufferedWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
            file.delete();
            file2.renameTo(file);
        }
        catch (Exception exception) {
            Log.log("Error save ignore words:" + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DictionaryEntry> findWords(Set<String> set) {
        ArrayList<DictionaryInfo> arrayList;
        Object object = this;
        synchronized (object) {
            arrayList = new ArrayList<DictionaryInfo>(this.infos.values());
        }
        object = new ArrayList();
        for (String string : set) {
            for (DictionaryInfo dictionaryInfo : arrayList) {
                try {
                    Object object2 = this.ignoreWords;
                    synchronized (object2) {
                        if (this.ignoreWords.contains(string)) {
                            continue;
                        }
                    }
                    object2 = dictionaryInfo.info.get(string);
                    if (object2 == null) {
                        string = string.toLowerCase();
                        Set<String> set2 = this.ignoreWords;
                        synchronized (set2) {
                            if (this.ignoreWords.contains(string)) {
                                continue;
                            }
                        }
                        object2 = dictionaryInfo.info.get(string);
                    }
                    if (object2 == null) continue;
                    if (object2.getClass().isArray()) {
                        for (Object object3 : (Object[])object2) {
                            String string2 = dictionaryInfo.dict.readArticle(string, object3);
                            object.add(new DictionaryEntry(string, string2));
                        }
                        continue;
                    }
                    String string3 = dictionaryInfo.dict.readArticle(string, object2);
                    object.add(new DictionaryEntry(string, string3));
                }
                catch (Exception exception) {
                    Log.log(exception);
                }
            }
        }
        return object;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class DictionaryInfo {
        public final IDictionary dict;
        public final Map<String, Object> info;

        public DictionaryInfo(IDictionary iDictionary, Map<String, Object> map) {
            this.dict = iDictionary;
            this.info = map;
        }
    }
}

