/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.util.LFileCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StarDict
implements IDictionary {
    protected final File ifoFile;
    protected static final String UTF8 = "UTF-8";
    protected static final int BUFFER_SIZE = 65536;
    protected final String contentType;

    public StarDict(File file) throws Exception {
        this.ifoFile = file;
        Map<String, String> map = this.readIFO(file);
        String string = map.get("version");
        if (!"2.4.2".equals(string)) {
            throw new Exception("Invalid version of dictionary: " + string);
        }
        this.contentType = map.get("sametypesequence");
        if (!"g".equals(this.contentType) && !"m".equals(this.contentType)) {
            throw new Exception("Invalid type of dictionary: " + this.contentType);
        }
    }

    @Override
    public Map<String, Object> readHeader() throws IOException {
        int n;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        String string = this.ifoFile.getPath();
        if (string.endsWith(".ifo")) {
            string = string.substring(0, string.length() - 4);
        }
        File file = new File(string + ".idx");
        File file2 = new File(string + ".dict");
        byte[] byArray = this.readFile(file);
        byte[] byArray2 = this.readFile(file2);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = dataInputStream.read()) != -1) {
            if (n == 0) {
                String string2 = new String(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.size(), UTF8);
                byteArrayOutputStream.reset();
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                String string3 = this.readArticleText(byArray2, n2, n3);
                this.addArticle(string2, string3, hashMap);
                continue;
            }
            byteArrayOutputStream.write(n);
        }
        return hashMap;
    }

    private void addArticle(String string, String string2, Map<String, Object> map) {
        String[] stringArray = map.get(string);
        if (stringArray == null) {
            stringArray = string2;
        } else if (stringArray instanceof String[]) {
            String[] stringArray2 = stringArray;
            String[] stringArray3 = new String[stringArray2.length + 1];
            System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
            stringArray3[stringArray3.length - 1] = string2;
            stringArray = stringArray3;
        } else {
            String[] stringArray4 = new String[]{(String)stringArray, string2};
            stringArray = stringArray4;
        }
        map.put(string, stringArray);
    }

    @Override
    public String readArticle(String string, Object object) {
        return (String)object;
    }

    private String readArticleText(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, UTF8).replace("\n", "<br>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(File file) throws IOException {
        FilterInputStream filterInputStream;
        if (file.exists()) {
            filterInputStream = new BufferedInputStream(new FileInputStream(file), 65536);
        } else {
            File file2 = new File(file.getPath() + ".gz");
            if (!file2.exists()) {
                file2 = new File(file.getPath() + ".dz");
            }
            if (file2.exists()) {
                filterInputStream = new GZIPInputStream(new BufferedInputStream(new FileInputStream(file2), 65536));
            } else {
                throw new FileNotFoundException(file.getPath());
            }
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(65536);
        try {
            LFileCopy.copy((InputStream)filterInputStream, (OutputStream)byteArrayOutputStream);
        }
        finally {
            ((InputStream)filterInputStream).close();
        }
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> readIFO(File file) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), UTF8));
        try {
            String string = null;
            String string2 = bufferedReader.readLine();
            if (!"StarDict's dict ifo file".equals(string2)) {
                throw new Exception("Invalid header of .ifo file: " + string2);
            }
            TreeMap<String, String> treeMap = new TreeMap<String, String>();
            while ((string = bufferedReader.readLine()) != null) {
                if (string.trim().length() == 0) continue;
                int n = string.indexOf(61);
                if (n < 0) {
                    throw new Exception("Invalid format of .ifo file: " + string);
                }
                treeMap.put(string.substring(0, n), string.substring(n + 1));
            }
            TreeMap<String, String> treeMap2 = treeMap;
            return treeMap2;
        }
        finally {
            bufferedReader.close();
        }
    }
}

