/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import gen.core.segmentation.Languagemap;
import gen.core.segmentation.Languagerule;
import gen.core.segmentation.Srx;
import java.beans.ExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SRX
implements Serializable,
Cloneable {
    private static SRX srx = null;
    private static final String CONF_SENTSEG = "segmentation.conf";
    private static final File configFile = new File(StaticUtils.getConfigDir() + "segmentation.conf");
    protected static final JAXBContext SRX_JAXB_CONTEXT;
    private static final String DEFAULT_RULES_PATTERN = ".*";
    private boolean segmentSubflows = true;
    private boolean includeStartingTags;
    private boolean includeEndingTags = true;
    private boolean includeIsolatedTags;
    private List<MapRule> mappingRules = new ArrayList<MapRule>();
    public static String INITIAL_VERSION;
    public static String OT160RC8_VERSION;
    public static String OT160RC9_VERSION;
    public static String CURRENT_VERSION;
    private String version;

    public static SRX getSRX() {
        if (srx == null) {
            srx = SRX.load();
        }
        return srx;
    }

    public static void reload() {
        srx = SRX.load();
    }

    public static void init() {
        srx = new SRX();
        srx.initDefaults();
    }

    public void save() {
        try {
            this.setVersion(CURRENT_VERSION);
            XMLEncoder xMLEncoder = new XMLEncoder(new FileOutputStream(configFile));
            xMLEncoder.writeObject(this);
            xMLEncoder.close();
        }
        catch (IOException iOException) {
            Log.logErrorRB("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG", new Object[0]);
            Log.log(iOException);
            JOptionPane.showMessageDialog(null, OStrings.getString("CORE_SRX_ERROR_SAVING_SEGMENTATION_CONFIG") + "\n" + iOException, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private static SRX load() {
        SRX sRX;
        try {
            MyExceptionListener myExceptionListener = new MyExceptionListener();
            XMLDecoder xMLDecoder = new XMLDecoder(new FileInputStream(configFile), null, myExceptionListener);
            sRX = (SRX)xMLDecoder.readObject();
            xMLDecoder.close();
            if (myExceptionListener.isExceptionOccured()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (Exception exception : myExceptionListener.getExceptionsList()) {
                    stringBuffer.append("    ");
                    stringBuffer.append(exception);
                    stringBuffer.append("\n");
                }
                Log.logErrorRB("CORE_SRX_EXC_LOADING_SEG_RULES", stringBuffer.toString());
                sRX = new SRX();
                sRX.initDefaults();
                return sRX;
            }
            if (CURRENT_VERSION.compareTo(sRX.getVersion()) > 0) {
                SRX sRX2 = new SRX();
                sRX2.initDefaults();
                sRX = SRX.merge(sRX, sRX2);
            }
        }
        catch (Exception exception) {
            if (!(exception instanceof FileNotFoundException)) {
                Log.log(exception);
            }
            sRX = new SRX();
            sRX.initDefaults();
        }
        return sRX;
    }

    private static SRX merge(SRX sRX, SRX sRX2) {
        sRX = SRX.upgrade(sRX, sRX2);
        int n = sRX2.getMappingRules().size();
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            int n2;
            MapRule mapRule = sRX2.getMappingRules().get(i);
            String string = mapRule.getLanguageCode();
            boolean bl = false;
            int n3 = sRX.getMappingRules().size();
            MapRule mapRule2 = null;
            for (n2 = 0; n2 < n3; ++n2) {
                mapRule2 = sRX.getMappingRules().get(n2);
                object2 = mapRule2.getLanguageCode();
                if (!string.equals(object2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                List<Rule> list = mapRule2.getRules();
                object2 = mapRule.getRules();
                object = object2.iterator();
                while (object.hasNext()) {
                    int n4;
                    Rule rule = (Rule)object.next();
                    if (list.contains(rule)) continue;
                    if (rule.isBreakRule()) {
                        list.add(rule);
                        continue;
                    }
                    int n5 = n4 = list.size();
                    for (int j = 0; j < n4; ++j) {
                        Rule rule2 = list.get(j);
                        if (!rule2.isBreakRule()) continue;
                        n5 = j;
                        break;
                    }
                    list.add(n5, rule);
                }
                continue;
            }
            n2 = n3;
            for (int j = 0; j < n3; ++j) {
                mapRule2 = sRX.getMappingRules().get(j);
                object = mapRule2.getPattern();
                if (!DEFAULT_RULES_PATTERN.equals(object)) continue;
                n2 = j;
                break;
            }
            sRX.getMappingRules().add(n2, mapRule);
        }
        return sRX;
    }

    private static SRX upgrade(SRX sRX, SRX sRX2) {
        if (OT160RC9_VERSION.equals(CURRENT_VERSION)) {
            String string = "Default (English)";
            for (int i = 0; i < sRX.getMappingRules().size(); ++i) {
                MapRule mapRule = sRX.getMappingRules().get(i);
                if (!string.equals(mapRule.getLanguageCode())) continue;
                mapRule.setLanguage("Default");
                mapRule.getRules().removeAll(SRX.getRulesForLanguage(sRX2, "English"));
                mapRule.getRules().removeAll(SRX.getRulesForLanguage(sRX2, "Text"));
                mapRule.getRules().removeAll(SRX.getRulesForLanguage(sRX2, "HTML"));
            }
        }
        return sRX;
    }

    private static List<Rule> getRulesForLanguage(SRX sRX, String string) {
        for (MapRule mapRule : sRX.getMappingRules()) {
            if (!string.equals(mapRule.getLanguageCode())) continue;
            return mapRule.getRules();
        }
        return null;
    }

    private void initDefaults() {
        try {
            ArrayList<MapRule> arrayList = new ArrayList<MapRule>();
            URL uRL = this.getClass().getResource("defaultRules.xml");
            Srx srx = (Srx)SRX_JAXB_CONTEXT.createUnmarshaller().unmarshal(uRL);
            for (Languagerule languagerule : srx.getBody().getLanguagerules().getLanguagerule()) {
                String string = languagerule.getLanguagerulename();
                String string2 = DEFAULT_RULES_PATTERN;
                for (Languagemap languagemap : srx.getBody().getMaprules().getLanguagemap()) {
                    if (!languagemap.getLanguagerulename().equals(languagerule.getLanguagerulename())) continue;
                    string2 = languagemap.getLanguagepattern();
                    break;
                }
                ArrayList arrayList2 = new ArrayList(languagerule.getRule().size());
                for (gen.core.segmentation.Rule rule : languagerule.getRule()) {
                    boolean bl = "yes".equalsIgnoreCase(rule.getBreak());
                    arrayList2.add(new Rule(bl, rule.getBeforebreak().getContent(), rule.getAfterbreak().getContent()));
                }
                arrayList.add(new MapRule(string, string2, arrayList2));
            }
            this.getMappingRules().addAll(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public List<Rule> lookupRulesForLanguage(Language language) {
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        for (int i = 0; i < this.getMappingRules().size(); ++i) {
            MapRule mapRule = this.getMappingRules().get(i);
            if (!mapRule.getCompiledPattern().matcher(language.getLanguage()).matches()) continue;
            arrayList.addAll(mapRule.getRules());
        }
        return arrayList;
    }

    public boolean isSegmentSubflows() {
        return this.segmentSubflows;
    }

    public void setSegmentSubflows(boolean bl) {
        this.segmentSubflows = bl;
    }

    public boolean isIncludeStartingTags() {
        return this.includeStartingTags;
    }

    public void setIncludeStartingTags(boolean bl) {
        this.includeStartingTags = bl;
    }

    public boolean isIncludeEndingTags() {
        return this.includeEndingTags;
    }

    public void setIncludeEndingTags(boolean bl) {
        this.includeEndingTags = bl;
    }

    public boolean isIncludeIsolatedTags() {
        return this.includeIsolatedTags;
    }

    public void setIncludeIsolatedTags(boolean bl) {
        this.includeIsolatedTags = bl;
    }

    public List<MapRule> getMappingRules() {
        return this.mappingRules;
    }

    public void setMappingRules(List<MapRule> list) {
        this.mappingRules = list;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    static {
        try {
            SRX_JAXB_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{Srx.class});
        }
        catch (LinkageError linkageError) {
            throw new ExceptionInInitializerError(OStrings.getString("STARTUP_JAXB_LINKAGE_ERROR"));
        }
        catch (JAXBException jAXBException) {
            if (jAXBException.getMessage() != null) {
                throw new ExceptionInInitializerError(jAXBException.getMessage());
            }
            if (jAXBException.getCause() != null) {
                throw new ExceptionInInitializerError(jAXBException.getCause().getClass().getName() + ": " + jAXBException.getCause().getMessage());
            }
            throw new ExceptionInInitializerError(((Object)((Object)jAXBException)).getClass().getName());
        }
        INITIAL_VERSION = "0.2";
        OT160RC8_VERSION = "0.2.1";
        CURRENT_VERSION = OT160RC9_VERSION = "0.2.2";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyExceptionListener
    implements ExceptionListener {
        private List<Exception> exceptionsList = new ArrayList<Exception>();
        private boolean exceptionOccured = false;

        MyExceptionListener() {
        }

        @Override
        public void exceptionThrown(Exception exception) {
            this.exceptionOccured = true;
            this.exceptionsList.add(exception);
        }

        public boolean isExceptionOccured() {
            return this.exceptionOccured;
        }

        public List<Exception> getExceptionsList() {
            return this.exceptionsList;
        }
    }
}

