/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import org.omegat.core.spellchecker.DictionaryFileNameFilter;
import org.omegat.util.PatternConsts;
import org.omegat.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DictionaryManager {
    private File dir;

    public DictionaryManager(String string) {
        this.dir = new File(string);
    }

    public String getDirectory() {
        return this.dir.getAbsolutePath();
    }

    private String getFileNameOnly(String string) {
        int n = string.indexOf(".");
        if (n != -1) {
            return string.substring(0, n);
        }
        return null;
    }

    public List<String> getDictionaryNameList(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            String[] stringArray = string.split("_");
            Locale locale = stringArray.length == 1 ? new Locale(stringArray[0]) : new Locale(stringArray[0], stringArray[1]);
            arrayList.add(string + " - " + locale.getDisplayName());
        }
        return arrayList;
    }

    public List<String> getLocalDictionaryNameList() {
        return this.getDictionaryNameList(this.getLocalDictionaryCodeList());
    }

    public List<String> getLocalDictionaryCodeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.dir.list(new DictionaryFileNameFilter(".aff"));
        String[] stringArray2 = this.dir.list(new DictionaryFileNameFilter(".dic"));
        if (stringArray != null && stringArray2 != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = false;
                String string = this.getFileNameOnly(stringArray[i]);
                if (string == null || string.equals("")) continue;
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = this.getFileNameOnly(stringArray2[j]);
                    if (string2 == null || string2.equals("") || !string.equals(string2)) continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    public boolean uninstallDictionary(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = this.getDirectory() + File.separator + string;
        File file = new File(string2 + ".aff");
        if (!file.delete()) {
            return false;
        }
        File file2 = new File(string2 + ".dic");
        return file2.delete();
    }

    public List<String> getInstallableDictionaryNameList() throws IOException {
        return this.getDictionaryNameList(this.getInstallableDictionaryCodeList());
    }

    public List<String> getInstallableDictionaryCodeList() throws IOException {
        List<String> list = this.getLocalDictionaryCodeList();
        List<String> list2 = this.getRemoteDictionaryCodeList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list2) {
            if (list.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> getRemoteDictionaryCodeList() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = StaticUtils.downloadFileToString("http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries/");
        Matcher matcher = PatternConsts.DICTIONARY_ZIP.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group();
            int n = string2.indexOf(".");
            arrayList.add(string2.substring(1, n));
        }
        return arrayList;
    }

    public void installRemoteDictionary(String string) throws MalformedURLException, IOException {
        String string2 = "http://ftp.services.openoffice.org/pub/OpenOffice.org/contrib/dictionaries//" + string + ".zip";
        File file = File.createTempFile(string, ".zip");
        String string3 = file.getAbsolutePath();
        StaticUtils.downloadFileToDisk(string2, string3);
        int n = string.indexOf("_1-3-2", 0);
        if (n != -1) {
            string = string.substring(0, n);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string + ".aff");
        arrayList.add(string + ".dic");
        this.dir.mkdirs();
        StaticUtils.extractFileFromJar(string3, arrayList, this.dir.getAbsolutePath());
    }
}

