/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.latex;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatexFilter
extends AbstractFilter {
    private LinkedList<String> oneArgNoText = new LinkedList();
    private LinkedList<String> oneArgInlineText = new LinkedList();
    private LinkedList<String> oneArgParText = new LinkedList();

    @Override
    public String getFileFormatName() {
        return OStrings.getString("LATEXFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.tex"), new Instance("*.latex")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n != 65279) {
            bufferedReader.reset();
        }
        this.init();
        this.processLatexFile(bufferedReader, bufferedWriter);
    }

    private int findStringCategory(String string) {
        if (string.equals("\\")) {
            return 0;
        }
        if (string.equals("{")) {
            return 1;
        }
        if (string.equals("}")) {
            return 2;
        }
        if (string.equals("$")) {
            return 3;
        }
        if (string.equals("&")) {
            return 4;
        }
        if (string.equals("\n")) {
            return 5;
        }
        if (string.equals("#")) {
            return 6;
        }
        if (string.equals("^")) {
            return 7;
        }
        if (string.equals("_")) {
            return 8;
        }
        if (string.equals("\u0000")) {
            return 9;
        }
        if (string.matches("[ \t]")) {
            return 10;
        }
        if (string.matches("[a-zA-Z]")) {
            return 11;
        }
        if (string.equals("~")) {
            return 13;
        }
        if (string.equals("%")) {
            return 14;
        }
        return 12;
    }

    private void processLatexFile(BufferedReader bufferedReader, Writer writer) throws IOException {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<String> linkedList = new LinkedList<String>();
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = string.split("");
            String string2 = "N";
            for (int i = 1; i < stringArray.length; ++i) {
                String string3;
                StringBuffer stringBuffer2;
                String string4 = stringArray[i];
                int n = this.findStringCategory(string4);
                if (n == 0) {
                    stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(string4);
                    ++i;
                    while (i < stringArray.length) {
                        string3 = stringArray[i];
                        if (this.findStringCategory(string3) != 11) {
                            if (stringBuffer2.length() == 1) {
                                stringBuffer2.append(string3);
                                string2 = "M";
                                break;
                            }
                            --i;
                            string2 = "M";
                            break;
                        }
                        stringBuffer2.append(string3);
                        ++i;
                    }
                    if (!linkedList.contains(stringBuffer2.toString())) {
                        linkedList.add(stringBuffer2.toString());
                    }
                    stringBuffer.append(stringBuffer2);
                    continue;
                }
                if (n == 4) {
                    writer.write(this.processParagraph(linkedList, stringBuffer.toString()));
                    writer.write("&");
                    stringBuffer.setLength(0);
                    linkedList.clear();
                    continue;
                }
                if (n == 10) {
                    if (!string2.equals("M")) continue;
                    string2 = "S";
                    stringBuffer.append(string4);
                    continue;
                }
                if (n == 14) {
                    stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(string4);
                    ++i;
                    while (i < stringArray.length) {
                        string3 = stringArray[i];
                        stringBuffer2.append(string3);
                        ++i;
                    }
                    continue;
                }
                string2 = "M";
                stringBuffer.append(string4);
            }
            if (string2.equals("N")) {
                writer.write(this.processParagraph(linkedList, stringBuffer.toString()));
                writer.write("\n\n");
                stringBuffer.setLength(0);
                linkedList.clear();
                continue;
            }
            if (!string2.equals("M")) continue;
            stringBuffer.append(" ");
        }
        if (stringBuffer.length() > 0) {
            writer.write(this.processParagraph(linkedList, stringBuffer.toString()));
        }
    }

    private String substituteUnicode(String string) {
        string = string.replaceAll("\\\\\\\\", "<br0>");
        string = string.replaceAll("\\{?\\\\ss\\}?", "\u00c3\u009f");
        string = string.replaceAll("\\{?\\\\glqq\\}?(\\{\\})?", "\u301f");
        string = string.replaceAll("\\{?\\\\grqq\\}?(\\{\\})?", "\u301d");
        string = string.replaceAll("\\{?\\\\glq\\}?(\\{\\})?", "\u201a");
        string = string.replaceAll("\\{?\\\\grq\\}?(\\{\\})?", "\u2018");
        string = string.replaceAll("\\\\%", "%");
        string = string.replaceAll("\\\\-", "\u00ad");
        string = string.replaceAll("\\\\,", "\u2009");
        string = string.replaceAll("~", "\u00a0");
        return string;
    }

    private String resubstituteTex(String string) {
        string = string.replaceAll("\u00a0", "~");
        string = string.replaceAll("\u2009", "\\\\,");
        string = string.replaceAll("\u00ad", "\\\\-");
        string = string.replaceAll("%", "\\\\%");
        string = string.replaceAll("<br0>", "\\\\\\\\");
        return string;
    }

    private void init() {
        this.oneArgNoText.add("\\begin");
        this.oneArgNoText.add("\\end");
        this.oneArgNoText.add("\\cite");
        this.oneArgNoText.add("\\label");
        this.oneArgNoText.add("\\ref");
        this.oneArgNoText.add("\\pageref");
        this.oneArgNoText.add("\\pagestyle");
        this.oneArgNoText.add("\\thispagestyle");
        this.oneArgNoText.add("\\vspace");
        this.oneArgNoText.add("\\hspace");
        this.oneArgNoText.add("\\vskip");
        this.oneArgNoText.add("\\hskip");
        this.oneArgNoText.add("\\put");
        this.oneArgNoText.add("\\includegraphics");
        this.oneArgNoText.add("\\documentclass");
        this.oneArgNoText.add("\\usepackage");
        this.oneArgInlineText.add("\\emph");
        this.oneArgInlineText.add("\\textbf");
        this.oneArgInlineText.add("\\texttt");
        this.oneArgInlineText.add("\\textsf");
        this.oneArgInlineText.add("\\textit");
        this.oneArgInlineText.add("\\hbox");
        this.oneArgInlineText.add("\\mbox");
        this.oneArgInlineText.add("\\vbox");
        this.oneArgParText.add("\\typeout");
        this.oneArgParText.add("\\footnote");
        this.oneArgParText.add("\\author");
        this.oneArgParText.add("\\index");
        this.oneArgParText.add("\\title");
        this.oneArgParText.add("\\Chapter");
        this.oneArgParText.add("\\chapter");
        this.oneArgParText.add("\\section");
    }

    private String replaceOneArgNoText(LinkedList<String[]> linkedList, LinkedList<String> linkedList2, String string) {
        int n = 0;
        for (String string2 : linkedList2) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.oneArgNoText.contains(string2)) continue;
            String string3 = "\\" + string2 + "\\*?" + "(" + "\\[" + "[^\\]]*" + "\\]" + "|" + "\\(" + "[^\\)]*" + "\\)" + ")?\\s*" + "\\{" + "[^\\}]*+" + "\\}";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string4 = "<n" + String.valueOf(n) + ">";
                String[] stringArray = new String[]{this.reHarden(matcher.group(0)), this.reHarden(string4)};
                linkedList.addFirst(stringArray);
                matcher.appendReplacement(stringBuffer, string4);
                ++n;
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    private String replaceOneArgInlineText(LinkedList<String[]> linkedList, LinkedList<String> linkedList2, String string) {
        int n = 0;
        for (String string2 : linkedList2) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.oneArgInlineText.contains(string2)) continue;
            String string3 = "(\\" + string2 + "\\s*" + "\\{" + ")" + "(" + "[^\\}]*+" + ")" + "\\}";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string4 = "<i" + String.valueOf(n) + ">";
                String string5 = "</i" + String.valueOf(n) + ">";
                String[] stringArray = new String[]{this.reHarden(matcher.group(1)), this.reHarden(string4)};
                linkedList.addFirst(stringArray);
                String[] stringArray2 = new String[]{this.reHarden("}"), this.reHarden(string5)};
                linkedList.addFirst(stringArray2);
                String string6 = string4 + "$2" + string5;
                matcher.appendReplacement(stringBuffer, string6);
                ++n;
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    private String replaceOneArgParText(LinkedList<String[]> linkedList, LinkedList<String> linkedList2, String string) {
        int n = 0;
        for (String string2 : linkedList2) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.oneArgParText.contains(string2)) continue;
            String string3 = "(\\" + string2 + "\\*?\\s*" + ")" + "\\{" + "(" + "[^\\}]*+" + ")" + "\\}";
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string4 = "<p" + String.valueOf(n) + ">";
                String string5 = "";
                if (matcher.group(2) != null) {
                    string5 = this.processParagraph(linkedList2, matcher.group(2));
                }
                String[] stringArray = new String[]{this.reHarden(matcher.group(1) + "{" + string5 + "}"), this.reHarden(string4)};
                linkedList.addFirst(stringArray);
                matcher.appendReplacement(stringBuffer, string4);
                ++n;
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    private String replaceUnknownCommand(LinkedList<String[]> linkedList, LinkedList<String> linkedList2, String string) {
        int n = 0;
        for (String string2 : linkedList2) {
            if (string2.equals("\\\\") || string2.equals("\\{") || string2.equals("\\[")) {
                string2 = "\\" + string2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = "\\" + string2;
            Pattern pattern = Pattern.compile(string3);
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string4 = "<u" + String.valueOf(n) + ">";
                String[] stringArray = new String[]{this.reHarden(matcher.group(0)), this.reHarden(string4)};
                linkedList.addFirst(stringArray);
                matcher.appendReplacement(stringBuffer, string4);
                ++n;
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        return string;
    }

    private String reHarden(String string) {
        string = string.replaceAll("\\\\", "\\\\\\\\");
        string = string.replaceAll("\\[", "\\\\[");
        string = string.replaceAll("\\^", "\\\\^");
        string = string.replaceAll("\\$", "\\\\\\$");
        string = string.replaceAll("\\{", "\\\\{");
        return string;
    }

    private String processParagraph(LinkedList<String> linkedList, String string) {
        LinkedList<String[]> linkedList2 = new LinkedList<String[]>();
        string = this.substituteUnicode(string);
        string = this.replaceOneArgNoText(linkedList2, linkedList, string);
        string = this.replaceOneArgInlineText(linkedList2, linkedList, string);
        string = this.replaceOneArgParText(linkedList2, linkedList, string);
        string = this.replaceUnknownCommand(linkedList2, linkedList, string);
        String string2 = "^((\\s*</?[nipu]\\d+>\\s*)*)(.*?)((\\s*</?[nipu]\\d+>\\s*)*)$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            string = "";
            if (matcher.group(1) != null) {
                string = string + matcher.group(1);
            }
            if (matcher.group(3) != null) {
                string = string + this.processEntry(matcher.group(3));
            }
            if (matcher.group(4) != null) {
                string = string + matcher.group(4);
            }
        }
        string = this.resubstituteTex(string);
        ListIterator listIterator = linkedList2.listIterator();
        while (listIterator.hasNext()) {
            String[] stringArray = (String[])listIterator.next();
            string = string.replaceAll(stringArray[1], stringArray[0]);
        }
        return string;
    }
}

