/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.po;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.util.OStrings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PoFilter
extends AbstractFilter {
    protected static Pattern COMMENT_FUZZY = Pattern.compile("#, fuzzy");
    protected static Pattern COMMENT_FUZZY_OTHER = Pattern.compile("#,.* fuzzy.*");
    protected static Pattern COMMENT_NOWRAP = Pattern.compile("#,.* no-wrap.*");
    protected static Pattern MSG_ID = Pattern.compile("msgid(_plural)? \"(.*)\"");
    protected static Pattern MSG_STR = Pattern.compile("msgstr(\\[[0-9]+\\])? \"(.*)\"");
    protected static Pattern MSG_OTHER = Pattern.compile("\"(.*)\"");
    protected static String FUZZY_SOURCE_PREFIX = "[PO-fuzzy] ";
    protected static boolean FUZZY_TO_LEGACY = true;
    private StringBuilder[] sources;
    private StringBuilder[] targets;
    private boolean nowrap;
    private boolean fuzzy;
    private BufferedWriter out;
    protected static final Pattern R1 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\\"");
    protected static final Pattern R2 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\n");
    protected static final Pattern R3 = Pattern.compile("(?<!\\\\)((\\\\\\\\)*)\\\\t");
    protected static final Pattern R4 = Pattern.compile("^\\\\n");

    @Override
    public String getFileFormatName() {
        return OStrings.getString("POFILTER_FILTER_NAME");
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.po"), new Instance("*.pot")};
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    @Override
    public List<File> processFile(File file, String string, File file2, String string2) throws IOException, TranslationException {
        BufferedReader bufferedReader = this.createReader(file, string);
        BufferedWriter bufferedWriter = file2 != null ? this.createWriter(file2, string2) : null;
        this.processFile(bufferedReader, bufferedWriter);
        bufferedReader.close();
        if (bufferedWriter != null) {
            bufferedWriter.close();
        }
        return null;
    }

    @Override
    public void processFile(BufferedReader bufferedReader, BufferedWriter bufferedWriter) throws IOException {
        bufferedReader.mark(1);
        int n = bufferedReader.read();
        if (n != 65279) {
            bufferedReader.reset();
        }
        this.out = bufferedWriter;
        this.processPoFile(bufferedReader);
    }

    private void processPoFile(BufferedReader bufferedReader) throws IOException {
        String string;
        this.fuzzy = false;
        this.nowrap = false;
        MODE mODE = null;
        int n = 0;
        this.sources = new StringBuilder[2];
        this.sources[0] = new StringBuilder();
        this.sources[1] = new StringBuilder();
        this.targets = new StringBuilder[2];
        this.targets[0] = new StringBuilder();
        this.targets[1] = new StringBuilder();
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            if (COMMENT_FUZZY.matcher(string).matches()) {
                this.fuzzy = true;
                this.flushTranslation(mODE);
                continue;
            }
            if (COMMENT_FUZZY_OTHER.matcher(string).matches()) {
                this.fuzzy = true;
                this.flushTranslation(mODE);
                string = string.replaceAll("(.*), fuzzy(.*)", "$1$2");
            }
            if (COMMENT_NOWRAP.matcher(string).matches()) {
                this.flushTranslation(mODE);
                this.nowrap = true;
                this.eol(string);
                continue;
            }
            Matcher matcher = MSG_ID.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(2);
                if (matcher.group(1) == null) {
                    mODE = MODE.MSGID;
                    this.sources[0].append(string2);
                } else {
                    mODE = MODE.MSGID_PLURAL;
                    this.sources[1].append(string2);
                }
                this.eol(string);
                continue;
            }
            matcher = MSG_STR.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(2);
                if (matcher.group(1) == null) {
                    mODE = MODE.MSGSTR;
                    this.targets[0].append(string2);
                    continue;
                }
                mODE = MODE.MSGSTR_PLURAL;
                if ("[0]".equals(matcher.group(1))) {
                    this.targets[0].append(string2);
                    n = 0;
                    continue;
                }
                if (!"[1]".equals(matcher.group(1))) continue;
                this.targets[1].append(string2);
                n = 1;
                continue;
            }
            matcher = MSG_OTHER.matcher(string);
            if (matcher.matches()) {
                string2 = matcher.group(1);
                switch (mODE) {
                    case MSGID: {
                        this.sources[0].append(string2);
                        this.eol(string);
                        break;
                    }
                    case MSGID_PLURAL: {
                        this.sources[1].append(string2);
                        this.eol(string);
                        break;
                    }
                    case MSGSTR: {
                        this.targets[0].append(string2);
                        break;
                    }
                    case MSGSTR_PLURAL: {
                        this.targets[n].append(string2);
                    }
                }
                continue;
            }
            this.flushTranslation(mODE);
            this.eol(string);
        }
        this.flushTranslation(mODE);
    }

    protected void eol(String string) throws IOException {
        if (this.out != null) {
            this.out.write(string);
            this.out.write(10);
        }
    }

    protected void align(int n) {
        String string = this.unescape(this.sources[n].toString());
        String string2 = this.unescape(this.targets[n].toString());
        this.align(string, string2);
    }

    protected void align(String string, String string2) {
        if (string2.length() == 0) {
            string2 = null;
        }
        if (!this.fuzzy) {
            this.entryProcessingCallback.addEntry(null, string, string2, null);
        } else if (FUZZY_TO_LEGACY) {
            this.entryProcessingCallback.addEntry(null, string, null, null);
            this.entryProcessingCallback.addLegacyTMXEntry(FUZZY_SOURCE_PREFIX + string, string2);
        } else {
            this.entryProcessingCallback.addEntry(null, FUZZY_SOURCE_PREFIX + string, string2, null);
        }
    }

    protected void alignHeader(String string) {
        this.entryProcessingCallback.addEntry(null, this.unescape(string), null, null);
    }

    protected void flushTranslation(MODE mODE) throws IOException {
        if (this.sources[0].length() == 0) {
            if (this.targets[0].length() == 0) {
                return;
            }
            if (this.out != null) {
                this.out.write("msgstr " + this.getTranslation(this.targets[0]) + "\n");
            } else {
                this.alignHeader(this.targets[0].toString());
            }
            this.fuzzy = false;
        } else {
            if (this.sources[1].length() == 0) {
                if (this.out != null) {
                    this.out.write("msgstr " + this.getTranslation(this.sources[0]) + "\n");
                } else {
                    this.align(0);
                }
            } else if (this.out != null) {
                this.out.write("msgstr[0] " + this.getTranslation(this.sources[0]) + "\n");
                this.out.write("msgstr[1] " + this.getTranslation(this.sources[1]) + "\n");
            } else {
                this.align(0);
                this.align(1);
            }
            this.fuzzy = false;
        }
        this.sources[0].setLength(0);
        this.sources[1].setLength(0);
        this.targets[0].setLength(0);
        this.targets[1].setLength(0);
    }

    private String getTranslation(StringBuilder stringBuilder) {
        String string = this.unescape(stringBuilder.toString());
        String string2 = this.entryProcessingCallback.getTranslation(null, string);
        if (string2 != null) {
            return "\"" + this.escape(string2) + "\"";
        }
        return "\"\"";
    }

    private String unescape(String string) {
        string = R1.matcher(string).replaceAll("$1\"");
        string = R2.matcher(string).replaceAll("$1\n");
        string = R3.matcher(string).replaceAll("$1\t");
        string = R4.matcher(string).replaceAll("\\\n");
        string = string.replace("\\\\", "\\");
        return string;
    }

    private String escape(String string) {
        string = string.replace("\\", "\\\\");
        string = string.replace("\"", "\\\"");
        string = string.replace("\\\\r", "\\r");
        if ((string = string.replace("\n", "\\n\"\n\"")).endsWith("\"\n\"")) {
            string = string.substring(0, string.length() - 3);
        }
        if (this.nowrap && string.contains("\n")) {
            string = "\"\n\"" + string;
        }
        string = string.replace("\t", "\\t");
        return string;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        MSGID,
        MSGSTR,
        MSGID_PLURAL,
        MSGSTR_PLURAL;

    }
}

