/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.omegat.filters2.text.TextOptions;
import org.omegat.util.OStrings;
import org.openide.awt.Mnemonics;

public class TextOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private TextOptions options;
    private JRadioButton breaksRB;
    private ButtonGroup buttonGroup1;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton emptyLinesRB;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JRadioButton neverRB;
    private JButton okButton;
    private int returnStatus = 0;

    public TextOptionsDialog(Dialog dialog, TextOptions textOptions) {
        super(dialog, true);
        this.options = textOptions;
        this.initComponents();
        if (textOptions == null) {
            textOptions = new TextOptions();
        }
        switch (textOptions.getSegmentOn()) {
            case 1: {
                this.breaksRB.setSelected(true);
                break;
            }
            case 2: {
                this.emptyLinesRB.setSelected(true);
                break;
            }
            case 3: {
                this.neverRB.setSelected(true);
            }
        }
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextOptionsDialog.this.doClose(0);
            }
        };
        this.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public TextOptions getOptions() {
        return this.options;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.breaksRB = new JRadioButton();
        this.emptyLinesRB = new JRadioButton();
        this.neverRB = new JRadioButton();
        this.setTitle(OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_TITLE"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextOptionsDialog.this.closeDialog(windowEvent);
            }
        });
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextOptionsDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText((AbstractButton)this.cancelButton, (String)OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextOptionsDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.jPanel1.setLayout(new GridLayout(0, 1, 0, 3));
        this.jPanel1.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)OStrings.getString("TEXTFILTER_OPTIONS_DIALOG_DESCRIPTION"));
        this.jPanel1.add(this.jLabel1);
        this.buttonGroup1.add(this.breaksRB);
        Mnemonics.setLocalizedText((AbstractButton)this.breaksRB, (String)OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_LINE_BREAKS"));
        this.jPanel1.add(this.breaksRB);
        this.buttonGroup1.add(this.emptyLinesRB);
        this.emptyLinesRB.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.emptyLinesRB, (String)OStrings.getString("TEXTFILTER_OPTION_SEGMENT_ON_EMPTY_LINES"));
        this.jPanel1.add(this.emptyLinesRB);
        this.buttonGroup1.add(this.neverRB);
        Mnemonics.setLocalizedText((AbstractButton)this.neverRB, (String)OStrings.getString("TEXTFILTER_OPTION_NEVER_SEGMENT"));
        this.jPanel1.add(this.neverRB);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.options = new TextOptions();
        if (this.breaksRB.isSelected()) {
            this.options.setSegmentOn(1);
        } else if (this.emptyLinesRB.isSelected()) {
            this.options.setSegmentOn(2);
        } else if (this.neverRB.isSelected()) {
            this.options.setSegmentOn(3);
        }
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.doClose(0);
    }

    private void doClose(int n) {
        this.returnStatus = n;
        this.setVisible(false);
        this.dispose();
    }
}

